/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/DocumentUtil", "executeInBulk"));
        }
        if (!(document instanceof DocumentEx)) {
            task.run();
            return;
        }
        DocumentEx documentEx = (DocumentEx)document;
        if (executeInBulk == documentEx.isInBulkUpdate()) {
            task.run();
            return;
        }
        documentEx.setInBulkUpdate(executeInBulk);
        try {
            task.run();
            documentEx.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            documentEx.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/DocumentUtil", "writeInRunUndoTransparentAction"));
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/DocumentUtil", "lambda$writeInRunUndoTransparentAction$0"));
            }
            ApplicationManager.getApplication().runWriteAction(runnable);
        });
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getFirstNonSpaceCharOffset"));
        }
        CharSequence text2 = document.getImmutableCharSequence();
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            char c = text2.charAt(i2);
            if (c == ' ' || c == '\t') continue;
            return i2;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isValidOffset"));
        }
        return offset >= 0 && offset <= document.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineStartOffset"));
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineEndOffset"));
        }
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getLineTextRange"));
        }
        TextRange textRange = TextRange.create(document.getLineStartOffset(line), document.getLineEndOffset(line));
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/DocumentUtil", "getLineTextRange"));
        }
        return textRange;
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isAtLineStart"));
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineStartOffset(document.getLineNumber(offset));
    }

    public static boolean isAtLineEnd(int offset, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isAtLineEnd"));
        }
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineEndOffset(document.getLineNumber(offset));
    }

    public static int alignToCodePointBoundary(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "alignToCodePointBoundary"));
        }
        return DocumentUtil.isInsideSurrogatePair(document, offset) ? offset - 1 : offset;
    }

    public static boolean isSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isSurrogatePair"));
        }
        CharSequence text2 = document.getImmutableCharSequence();
        if (offset < 0 || offset + 1 >= text2.length()) {
            return false;
        }
        return Character.isSurrogatePair(text2.charAt(offset), text2.charAt(offset + 1));
    }

    public static boolean isInsideSurrogatePair(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "isInsideSurrogatePair"));
        }
        return DocumentUtil.isSurrogatePair(document, offset - 1);
    }

    public static int getPreviousCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getPreviousCodePointOffset"));
        }
        return offset - (DocumentUtil.isSurrogatePair(document, offset - 2) ? 2 : 1);
    }

    public static int getNextCodePointOffset(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/DocumentUtil", "getNextCodePointOffset"));
        }
        return offset + (DocumentUtil.isSurrogatePair(document, offset) ? 2 : 1);
    }
}

