/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextRangeUtil {
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange range1, TextRange range2) {
            int startOffsetDiff = range1.getStartOffset() - range2.getStartOffset();
            return startOffsetDiff != 0 ? startOffsetDiff : range1.getEndOffset() - range2.getEndOffset();
        }
    };

    private TextRangeUtil() {
    }

    public static Iterable<TextRange> excludeRanges(@NotNull TextRange original, @NotNull List<TextRange> excludedRanges) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/text/TextRangeUtil", "excludeRanges"));
        }
        if (excludedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRanges", "com/intellij/util/text/TextRangeUtil", "excludeRanges"));
        }
        if (!excludedRanges.isEmpty()) {
            if (excludedRanges.size() > 1) {
                Collections.sort(excludedRanges, RANGE_COMPARATOR);
            }
            int enabledRangeStart = original.getStartOffset();
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            for (TextRange excludedRange : excludedRanges) {
                if (excludedRange.getEndOffset() < enabledRangeStart) continue;
                int excludedRangeStart = excludedRange.getStartOffset();
                if (excludedRangeStart > original.getEndOffset()) break;
                if (excludedRangeStart > enabledRangeStart) {
                    enabledRanges.add(new TextRange(enabledRangeStart, excludedRangeStart));
                }
                enabledRangeStart = excludedRange.getEndOffset();
            }
            if (enabledRangeStart < original.getEndOffset()) {
                enabledRanges.add(new TextRange(enabledRangeStart, original.getEndOffset()));
            }
            return enabledRanges;
        }
        return Collections.singletonList(original);
    }

    @NotNull
    public static TextRange getEnclosingTextRange(@NotNull List<TextRange> textRanges) {
        if (textRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRanges", "com/intellij/util/text/TextRangeUtil", "getEnclosingTextRange"));
        }
        if (textRanges.isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/TextRangeUtil", "getEnclosingTextRange"));
            }
            return textRange;
        }
        int lowerBound = textRanges.get(0).getStartOffset();
        int upperBound = textRanges.get(0).getEndOffset();
        for (int i2 = 1; i2 < textRanges.size(); ++i2) {
            TextRange textRange = textRanges.get(i2);
            lowerBound = Math.min(lowerBound, textRange.getStartOffset());
            upperBound = Math.max(upperBound, textRange.getEndOffset());
        }
        TextRange textRange = new TextRange(lowerBound, upperBound);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/TextRangeUtil", "getEnclosingTextRange"));
        }
        return textRange;
    }
}

