/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiProvidesStatement;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeProvidesStatementsFix
extends MergeModuleStatementsFix<PsiProvidesStatement> {
    private final String myInterfaceName;

    MergeProvidesStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String interfaceName) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "<init>"));
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaceName", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "<init>"));
        }
        super(javaModule);
        this.myInterfaceName = interfaceName;
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.name", "provides", this.myInterfaceName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getText"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", "provides");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<PsiProvidesStatement> statementsToMerge) {
        if (statementsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementsToMerge", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getReplacementText"));
        }
        List<String> implementationNames = MergeProvidesStatementsFix.getImplementationNames(statementsToMerge);
        LOG.assertTrue(!implementationNames.isEmpty());
        String string = "provides " + this.myInterfaceName + " " + "with" + " " + MergeProvidesStatementsFix.joinUniqueNames(implementationNames) + ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getReplacementText"));
        }
        return string;
    }

    @NotNull
    private static List<String> getImplementationNames(@NotNull List<PsiProvidesStatement> statements) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getImplementationNames"));
        }
        List list = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(statements).map(PsiProvidesStatement::getImplementationList).nonNull()).flatMap(implementationList -> Arrays.stream(implementationList.getReferenceElements())).nonNull()).map(PsiJavaCodeReferenceElement::getQualifiedName).nonNull()).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getImplementationNames"));
        }
        return list;
    }

    @Override
    @NotNull
    protected List<PsiProvidesStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getStatementsToMerge"));
        }
        List list = ((StreamEx)StreamEx.of(javaModule.getProvides().iterator()).filter(statement -> {
            PsiJavaCodeReferenceElement reference = statement.getInterfaceReference();
            return reference != null && this.myInterfaceName.equals(reference.getQualifiedName());
        })).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeProvidesStatementsFix", "getStatementsToMerge"));
        }
        return list;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiProvidesStatement statement) {
        String interfaceName;
        PsiJavaCodeReferenceElement interfaceReference;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (interfaceReference = statement.getInterfaceReference()) != null && (interfaceName = interfaceReference.getQualifiedName()) != null) {
            return new MergeProvidesStatementsFix((PsiJavaModule)parent, interfaceName);
        }
        return null;
    }
}

