/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.ContractAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class InOutAnalysis
extends ContractAnalysis {
    protected InOutAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, State[] pending) {
        super(richControlFlow, direction, resultOrigins, stable, pending);
    }

    @Override
    boolean handleReturn(Frame<BasicValue> frame, int opcode) throws AnalyzerException {
        if (this.interpreter.deReferenced) {
            return true;
        }
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                Result subResult;
                BasicValue stackTop = InOutAnalysis.popValue(frame);
                if (AbstractValues.FalseValue == stackTop) {
                    subResult = new Final(Value.False);
                } else if (AbstractValues.TrueValue == stackTop) {
                    subResult = new Final(Value.True);
                } else if (AbstractValues.NullValue == stackTop) {
                    subResult = new Final(Value.Null);
                } else if (stackTop instanceof AbstractValues.NotNullValue) {
                    subResult = new Final(Value.NotNull);
                } else if (stackTop instanceof AbstractValues.ParamValue) {
                    subResult = new Final(this.inValue);
                } else if (stackTop instanceof AbstractValues.CallResultValue) {
                    Set<EKey> keys = ((AbstractValues.CallResultValue)stackTop).inters;
                    subResult = new Pending(new Component[]{new Component(Value.Top, keys)});
                } else {
                    this.earlyResult = new Final(Value.Top);
                    return true;
                }
                this.internalResult = InOutAnalysis.checkLimit(resultUtil.join(this.internalResult, subResult));
                if (this.internalResult instanceof Final && ((Final)this.internalResult).value == Value.Top) {
                    this.earlyResult = this.internalResult;
                }
                return true;
            }
            case 191: {
                return true;
            }
        }
        return false;
    }
}

