/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class SimplifyToAssignmentFix
implements LocalQuickFix {
    @Override
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message("inspection.data.flow.simplify.to.assignment.quickfix.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/fix/SimplifyToAssignmentFix", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message("inspection.data.flow.simplify.boolean.expression.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/fix/SimplifyToAssignmentFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/fix/SimplifyToAssignmentFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/fix/SimplifyToAssignmentFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = PsiTreeUtil.getParentOfType(psiElement, PsiAssignmentExpression.class);
        if (assignmentExpression == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        String lExpressionText = assignmentExpression.getLExpression().getText();
        PsiExpression rExpression = assignmentExpression.getRExpression();
        String rExpressionText = rExpression != null ? rExpression.getText() : "";
        assignmentExpression.replace(factory.createExpressionFromText(lExpressionText + " = " + rExpressionText, psiElement));
    }
}

