/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.FloatStoredProperty;
import com.intellij.openapi.components.IntStoredProperty;
import com.intellij.openapi.components.NormalizedStringStoredProperty;
import com.intellij.openapi.components.ObjectStoredProperty;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u0013\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0004J\u0006\u0010\u0018\u001a\u00020\u0010J%\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0\u001a\"\u0004\b\u0000\u0010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u0001H\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\nJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001eJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u0016J\u001a\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u00020 H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/components/BaseState;", "Lcom/intellij/util/xmlb/SerializationFilter;", "Lcom/intellij/openapi/util/ModificationTracker;", "()V", "ownModificationCount", "", "properties", "", "Lcom/intellij/openapi/components/StoredProperty;", "accepts", "", "accessor", "Lcom/intellij/util/xmlb/Accessor;", "bean", "", "copyFrom", "", "state", "equals", "other", "getModificationCount", "hashCode", "", "incrementModificationCount", "resetModificationCount", "storedProperty", "Lcom/intellij/openapi/components/StoredPropertyBase;", "T", "defaultValue", "(Ljava/lang/Object;)Lcom/intellij/openapi/components/StoredPropertyBase;", "", "string", "", "toString", "projectModel-api"})
public abstract class BaseState
implements SerializationFilter,
ModificationTracker {
    private final List<StoredProperty> properties = new SmartList();
    @Transient
    @JvmField
    public volatile long ownModificationCount;

    public final void resetModificationCount() {
        this.ownModificationCount = 0L;
    }

    protected final void incrementModificationCount() {
        long l = this.ownModificationCount;
        this.ownModificationCount = l + 1L;
    }

    @NotNull
    public final <T> StoredPropertyBase<T> storedProperty(@Nullable T defaultValue) {
        ObjectStoredProperty<T> result = new ObjectStoredProperty<T>(defaultValue);
        this.properties.add(result);
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredPropertyBase storedProperty$default(BaseState baseState, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storedProperty");
        }
        if ((n & 1) != 0) {
            object = null;
        }
        return baseState.storedProperty(object);
    }

    @NotNull
    public final StoredPropertyBase<String> string(@Nullable String defaultValue) {
        NormalizedStringStoredProperty result = new NormalizedStringStoredProperty(defaultValue);
        this.properties.add(result);
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredPropertyBase string$default(BaseState baseState, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: string");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return baseState.string(string);
    }

    @NotNull
    public final StoredPropertyBase<Integer> storedProperty(int defaultValue) {
        IntStoredProperty result = new IntStoredProperty(defaultValue);
        this.properties.add(result);
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredPropertyBase storedProperty$default(BaseState baseState, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storedProperty");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return baseState.storedProperty(n);
    }

    @NotNull
    public final StoredPropertyBase<Float> storedProperty(float defaultValue) {
        FloatStoredProperty result = new FloatStoredProperty(defaultValue);
        this.properties.add(result);
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredPropertyBase storedProperty$default(BaseState baseState, float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storedProperty");
        }
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        return baseState.storedProperty(f);
    }

    @NotNull
    public final StoredPropertyBase<Boolean> storedProperty(boolean defaultValue) {
        ObjectStoredProperty<Boolean> result = new ObjectStoredProperty<Boolean>(defaultValue);
        this.properties.add(result);
        return result;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StoredPropertyBase storedProperty$default(BaseState baseState, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: storedProperty");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return baseState.storedProperty(bl);
    }

    @Override
    public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
        Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
        Intrinsics.checkParameterIsNotNull((Object)bean, (String)"bean");
        for (StoredProperty property : this.properties) {
            if (!Intrinsics.areEqual((Object)property.getName(), (Object)accessor.getName())) continue;
            return Intrinsics.areEqual((Object)property.getValue(), (Object)property.getDefaultValue()) ^ true;
        }
        return false;
    }

    @Override
    @Transient
    public long getModificationCount() {
        long result = this.ownModificationCount;
        for (StoredProperty property : this.properties) {
            Object value = property.getValue();
            if (!(value instanceof ModificationTracker)) continue;
            result += ((ModificationTracker)value).getModificationCount();
        }
        return result;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof BaseState && Intrinsics.areEqual(this.properties, ((BaseState)other).properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    @NotNull
    public String toString() {
        if (this.properties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (StoredProperty property : this.properties) {
            builder.append(property.getValue()).append(" ");
        }
        builder.setLength(builder.length() - 1);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public final void copyFrom(@NotNull BaseState state) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        boolean bl2 = bl = state.properties.size() == this.properties.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean changed = false;
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.properties)) {
            int index = indexedValue.component1();
            StoredProperty property = (StoredProperty)indexedValue.component2();
            StoredProperty otherProperty = state.properties.get(index);
            if (property.getName() != null) {
                if (otherProperty.getName() == null) {
                    otherProperty.setName(property.getName());
                } else {
                    boolean bl3 = Intrinsics.areEqual((Object)otherProperty.getName(), (Object)property.getName());
                    if (_Assertions.ENABLED && !bl3) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                }
            }
            if (!property.setValue(otherProperty)) continue;
            changed = true;
        }
        if (changed) {
            this.incrementModificationCount();
        }
    }
}

