/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModulesScope
extends GlobalSearchScope {
    private final ProjectFileIndex myProjectFileIndex;
    private final Set<Module> myModules;

    public ModulesScope(@NotNull Set<Module> modules, @NotNull Project project) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/module/impl/scopes/ModulesScope", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/scopes/ModulesScope", "<init>"));
        }
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.myModules = modules;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/impl/scopes/ModulesScope", "contains"));
        }
        Module moduleOfFile = this.myProjectFileIndex.getModuleForFile(file);
        return moduleOfFile != null && this.myModules.contains(moduleOfFile);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/openapi/module/impl/scopes/ModulesScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/openapi/module/impl/scopes/ModulesScope", "compare"));
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/openapi/module/impl/scopes/ModulesScope", "isSearchInModuleContent"));
        }
        return this.myModules.contains(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    public String toString() {
        return "Modules:" + Arrays.toString(this.myModules.toArray(new Module[this.myModules.size()]));
    }
}

