/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.ReplaceChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeChangeImpl
implements TreeChange {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.events.impl.TreeChangeImpl");
    private final Map<ASTNode, ChangeInfo> myChanges = new THashMap();
    private final List<Pair<ASTNode, Integer>> mySortedChanges = new ArrayList<Pair<ASTNode, Integer>>();
    private final ASTNode myParent;
    private static final int haveNotCalculated = -1;
    private int myLastOffsetInNewTree;
    private ASTNode myLastNode;

    public TreeChangeImpl(ASTNode parent) {
        this.myParent = parent;
    }

    @Override
    public void addChange(ASTNode child, @NotNull ChangeInfo changeInfo) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "addChange"));
        }
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        ChangeInfo current = this.myChanges.get(child);
        if (current != null && changeInfo.getChangeType() == 3) {
            return;
        }
        if (changeInfo.getChangeType() == 2) {
            ReplaceChangeInfoImpl replaceChangeInfo = (ReplaceChangeInfoImpl)changeInfo;
            ASTNode replaced = replaceChangeInfo.getReplaced();
            ChangeInfo replacedInfo = this.myChanges.get(replaced);
            if (replacedInfo == null) {
                this.addChangeInternal(child, changeInfo);
            } else {
                switch (replacedInfo.getChangeType()) {
                    case 2: {
                        replaceChangeInfo.setOldLength(replacedInfo.getOldLength());
                        replaceChangeInfo.setReplaced(((ReplaceChangeInfo)((Object)replacedInfo)).getReplaced());
                        break;
                    }
                    case 0: {
                        changeInfo = ChangeInfoImpl.create((short)0, replaced);
                        this.removeChangeInternal(replaced);
                    }
                }
                this.addChangeInternal(child, changeInfo);
            }
            return;
        }
        if (current != null && current.getChangeType() == 1) {
            if (changeInfo.getChangeType() == 0) {
                if (!(child instanceof LeafElement)) {
                    changeInfo = ChangeInfoImpl.create((short)3, child);
                    ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
                    this.myChanges.put(child, changeInfo);
                } else {
                    this.removeChangeInternal(child);
                }
            }
            return;
        }
        if (current != null && current.getChangeType() == 0) {
            if (changeInfo.getChangeType() == 1) {
                this.removeChangeInternal(child);
            }
            return;
        }
        if (changeInfo.getChangeType() == 1) {
            if (child instanceof LeafElement) {
                CharSequence charTabIndex = child.getChars();
                if (this.checkLeaf(child.getTreeNext(), charTabIndex) || this.checkLeaf(child.getTreePrev(), charTabIndex)) {
                    return;
                }
            }
            this.addChangeInternal(child, changeInfo);
            if (current != null) {
                ((ChangeInfoImpl)changeInfo).setOldLength(current.getOldLength());
            }
            return;
        }
        if (current == null) {
            this.addChangeInternal(child, changeInfo);
        }
    }

    private void addChangeInternal(ASTNode child, ChangeInfo info) {
        if (!this.myChanges.containsKey(child)) {
            int nodeOffset = this.getNodeOldOffset(child, info);
            this.addChangeAtOffset(child, nodeOffset);
        }
        this.myChanges.put(child, info);
    }

    private void addChangeAtOffset(ASTNode child, int nodeOffset) {
        Pair<ASTNode, Integer> pair;
        Pair<ASTNode, Integer> element = Pair.create(child, nodeOffset);
        if (this.mySortedChanges.size() > 0 && (pair = this.mySortedChanges.get(this.mySortedChanges.size() - 1)).getFirst() == child.getTreePrev() && pair.getSecond() <= nodeOffset) {
            this.mySortedChanges.add(element);
            return;
        }
        int index = 0;
        for (Pair<ASTNode, Integer> pair2 : this.mySortedChanges) {
            if (child == pair2.getFirst()) {
                return;
            }
            if (nodeOffset < pair2.getSecond() || nodeOffset == pair2.getSecond() && TreeChangeImpl.isAfter(pair2.getFirst(), child)) break;
            ++index;
        }
        if (index == this.mySortedChanges.size()) {
            this.mySortedChanges.add(element);
        } else {
            this.mySortedChanges.add(index, element);
        }
    }

    private static boolean isAfter(ASTNode what, ASTNode afterWhat) {
        ASTNode previous = afterWhat;
        ASTNode current = previous.getTreeNext();
        while (current != null) {
            if (current == what) {
                return what.getTreePrev() == previous;
            }
            previous = current;
            if ((current = previous.getTreeNext()) == null || current.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private void removeChangeInternal(ASTNode child) {
        this.myChanges.remove(child);
        int n = this.mySortedChanges.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (child != this.mySortedChanges.get(i2).getFirst()) continue;
            this.mySortedChanges.remove(i2);
            break;
        }
    }

    private boolean checkLeaf(ASTNode treeNext, CharSequence charTabIndex) {
        if (!(treeNext instanceof LeafElement)) {
            return false;
        }
        ChangeInfo right = this.myChanges.get(treeNext);
        if (right != null && right.getChangeType() == 0 && charTabIndex == treeNext.getChars()) {
            this.removeChangeInternal(treeNext);
            return true;
        }
        return false;
    }

    @NotNull
    public TreeElement[] getAffectedChildren() {
        TreeElement[] treeElements = new TreeElement[this.myChanges.size()];
        int index = 0;
        for (Pair<ASTNode, Integer> pair : this.mySortedChanges) {
            treeElements[index++] = (TreeElement)pair.getFirst();
        }
        if (treeElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "getAffectedChildren"));
        }
        return treeElements;
    }

    @Override
    public ChangeInfo getChangeByChild(ASTNode child) {
        return this.myChanges.get(child);
    }

    @Override
    public int getChildOffsetInNewTree(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "getChildOffsetInNewTree"));
        }
        return this.myParent.getStartOffset() + this.getNewOffset(child);
    }

    @Override
    public void composite(@NotNull TreeChange treeChange) {
        if (treeChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeChange", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "composite"));
        }
        TreeChangeImpl change = (TreeChangeImpl)treeChange;
        Set<Map.Entry<ASTNode, ChangeInfo>> entries = change.myChanges.entrySet();
        for (Map.Entry<ASTNode, ChangeInfo> entry : entries) {
            this.addChange(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void removeChange(ASTNode beforeEqualDepth) {
        this.removeChangeInternal(beforeEqualDepth);
    }

    @Override
    public void add(@NotNull TreeChange value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/pom/tree/events/impl/TreeChangeImpl", "add"));
        }
        TreeChangeImpl impl = (TreeChangeImpl)value;
        LOG.assertTrue(impl.myParent == this.myParent);
        for (Pair<ASTNode, Integer> pair : impl.mySortedChanges) {
            ASTNode replaced;
            ASTNode child = pair.getFirst();
            ChangeInfo change = impl.myChanges.get(child);
            if (change.getChangeType() == 1) {
                ChangeInfo oldChange = this.myChanges.get(child);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            this.removeChangeInternal(child);
                            break;
                        }
                        case 2: {
                            replaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            this.removeChangeInternal(child);
                            this.myChanges.put(replaced, ChangeInfoImpl.create((short)1, replaced));
                            this.addChangeAtOffset(replaced, this.getOldOffset(pair.getSecond()));
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            this.myChanges.put(child, change);
                        }
                    }
                    continue;
                }
                this.myChanges.put(child, change);
                this.addChangeAtOffset(child, this.getOldOffset(pair.getSecond()));
                continue;
            }
            if (change.getChangeType() == 2) {
                ReplaceChangeInfo replaceChangeInfo = (ReplaceChangeInfo)((Object)change);
                replaced = replaceChangeInfo.getReplaced();
                ChangeInfo oldChange = this.myChanges.get(replaced);
                if (oldChange != null) {
                    switch (oldChange.getChangeType()) {
                        case 0: {
                            change = ChangeInfoImpl.create((short)0, child);
                            break;
                        }
                        case 3: {
                            ((ChangeInfoImpl)change).setOldLength(oldChange.getOldLength());
                            break;
                        }
                        case 2: {
                            ASTNode oldReplaced = ((ReplaceChangeInfo)((Object)oldChange)).getReplaced();
                            ReplaceChangeInfoImpl rep = new ReplaceChangeInfoImpl(child);
                            rep.setReplaced(oldReplaced);
                            change = rep;
                        }
                    }
                    this.removeChangeInternal(replaced);
                }
                this.addChange(child, change);
                continue;
            }
            this.addChange(child, change);
        }
    }

    @Override
    public int getOldLength() {
        int oldLength = ((TreeElement)this.myParent).getNotCachedLength();
        for (Map.Entry<ASTNode, ChangeInfo> entry : this.myChanges.entrySet()) {
            ASTNode key = entry.getKey();
            ChangeInfo change = entry.getValue();
            int length = ((TreeElement)key).getNotCachedLength();
            switch (change.getChangeType()) {
                case 0: {
                    oldLength -= length;
                    break;
                }
                case 1: {
                    oldLength += length;
                    break;
                }
                case 2: 
                case 3: {
                    oldLength += change.getOldLength() - length;
                }
            }
        }
        return oldLength;
    }

    private static int getNewLength(ChangeInfo change, ASTNode node) {
        if (change.getChangeType() == 1) {
            return 0;
        }
        return node.getTextLength();
    }

    private int getOptimizedNodeOldOffset(ASTNode child, ChangeInfo changeInfo) {
        ChangeInfo prevSiblingChange;
        Pair<ASTNode, Integer> pair;
        ASTNode prevSibling = child.getTreePrev();
        if (prevSibling != null && this.mySortedChanges.size() > 0 && (pair = this.mySortedChanges.get(this.mySortedChanges.size() - 1)).getFirst() == prevSibling && ((prevSiblingChange = this.myChanges.get(prevSibling)).getChangeType() == 1 && changeInfo.getChangeType() == 1 || prevSiblingChange.getChangeType() == 0 && changeInfo.getChangeType() == 0)) {
            return pair.getSecond() + prevSiblingChange.getOldLength();
        }
        return -1;
    }

    private int getNodeOldOffset(ASTNode child, ChangeInfo changeInfo) {
        LOG.assertTrue(child.getTreeParent() == this.myParent);
        int oldOffsetInParent = this.getOptimizedNodeOldOffset(child, changeInfo);
        if (oldOffsetInParent == -1) {
            oldOffsetInParent = this.calculateOldOffsetLinearly(child);
        }
        return oldOffsetInParent;
    }

    private int calculateOldOffsetLinearly(ASTNode child) {
        int oldOffsetInParent = 0;
        for (ASTNode current = this.myParent.getFirstChildNode(); current != child; current = current.getTreeNext()) {
            if (this.myChanges.containsKey(current)) continue;
            oldOffsetInParent += current.getTextLength();
        }
        for (Pair<ASTNode, Integer> offset : this.mySortedChanges) {
            if (offset.getSecond() > oldOffsetInParent) break;
            ChangeInfo change = this.myChanges.get(offset.getFirst());
            oldOffsetInParent += change.getOldLength();
        }
        return oldOffsetInParent;
    }

    private int getOldOffset(int offset) {
        for (Pair<ASTNode, Integer> pair : this.mySortedChanges) {
            if (pair.getSecond() > offset) break;
            ChangeInfo change = this.myChanges.get(pair.getFirst());
            offset += change.getOldLength() - TreeChangeImpl.getNewLength(change, pair.getFirst());
        }
        return offset;
    }

    private int getNewOffset(ASTNode node) {
        ASTNode prev = node.getTreePrev();
        if (this.myLastNode == prev) {
            ChangeInfo prevChangeInfo = this.myChanges.get(prev);
            ChangeInfo changeInfo = this.myChanges.get(node);
            if (prevChangeInfo != null && changeInfo != null && prevChangeInfo.getChangeType() == 1 && changeInfo.getChangeType() == 1) {
                this.myLastNode = node;
                return this.myLastOffsetInNewTree;
            }
        }
        int currentOffsetInNewTree = 0;
        ASTNode current = this.myParent.getFirstChildNode();
        int i2 = 0;
        Pair<ASTNode, Integer> currentChange = i2 < this.mySortedChanges.size() ? this.mySortedChanges.get(i2) : null;
        int currentOldOffset = 0;
        while (current != null) {
            boolean counted = false;
            while (currentChange != null && currentOldOffset == currentChange.getSecond()) {
                if (currentChange.getFirst() == node) {
                    this.myLastNode = node;
                    this.myLastOffsetInNewTree = currentOffsetInNewTree;
                    return currentOffsetInNewTree;
                }
                if (current == currentChange.getFirst()) {
                    int textLength = current.getTextLength();
                    counted = true;
                    current = current.getTreeNext();
                    currentOffsetInNewTree += textLength;
                }
                ChangeInfo changeInfo = this.myChanges.get(currentChange.getFirst());
                currentOldOffset += changeInfo.getOldLength();
                currentChange = ++i2 < this.mySortedChanges.size() ? this.mySortedChanges.get(i2) : null;
            }
            if (current == null) break;
            if (counted) continue;
            int textLength = current.getTextLength();
            currentOldOffset += textLength;
            current = current.getTreeNext();
            currentOffsetInNewTree += textLength;
        }
        return currentOffsetInNewTree;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<Pair<ASTNode, Integer>> iterator = this.mySortedChanges.iterator();
        while (iterator.hasNext()) {
            Pair<ASTNode, Integer> pair = iterator.next();
            ASTNode node = pair.getFirst();
            buffer.append("(");
            buffer.append(node.getElementType().toString());
            buffer.append(" at ").append(pair.getSecond()).append(", ");
            ChangeInfo child = this.getChangeByChild(node);
            buffer.append(child != null ? child.toString() : "null");
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

