/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = new Comparator<MessageBusImpl>(){

        @Override
        public int compare(MessageBusImpl bus1, MessageBusImpl bus2) {
            return ContainerUtil.compareLexicographically((List)bus1.myOrderRef.get(), (List)bus2.myOrderRef.get());
        }
    };
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private final AtomicReference<List<Integer>> myOrderRef;
    private final ConcurrentMap<Topic, Object> mySyncPublishers;
    private final ConcurrentMap<Topic, Object> myAsyncPublishers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers;
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final Deque<MessageBusImpl> myChildBuses;
    private final ConcurrentMap<List<Integer>, Boolean> myChildOrders;
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;

    public MessageBusImpl(@NotNull Object owner, @NotNull MessageBus parentBus) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl", "<init>"));
        }
        if (parentBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentBus", "com/intellij/util/messages/impl/MessageBusImpl", "<init>"));
        }
        this(owner);
        this.myParentBus = (MessageBusImpl)parentBus;
        this.myParentBus.onChildBusCreated(this);
        LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        LOG.assertTrue(this.myOrderRef.get() != null);
    }

    private MessageBusImpl(Object owner) {
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myOrderRef = new AtomicReference(Collections.emptyList());
        this.mySyncPublishers = ContainerUtil.newConcurrentMap();
        this.myAsyncPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = new LinkedBlockingDeque<MessageBusImpl>();
        this.myChildOrders = ContainerUtil.newConcurrentMap();
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    @NotNull
    private RootBus getRootBus() {
        RootBus rootBus = this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
        if (rootBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "getRootBus"));
        }
        return rootBus;
    }

    private MessageBusImpl rootBus() {
        return this.getRootBus();
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    private void onChildBusCreated(MessageBusImpl childBus) {
        LOG.assertTrue(childBus.myParentBus == this);
        ArrayList<Integer> childOrder = new ArrayList<Integer>(this.myOrderRef.get().size() + 1);
        childOrder.addAll((Collection)this.myOrderRef.get());
        childOrder.add(1);
        do {
            int lastChildIndex;
            MessageBusImpl lastChild;
            if ((lastChild = this.myChildBuses.peekLast()) == null) {
                lastChildIndex = 0;
            } else {
                List<Integer> lastChildOrder = lastChild.myOrderRef.get();
                lastChildIndex = lastChildOrder.get(lastChildOrder.size() - 1);
            }
            if (lastChildIndex == Integer.MAX_VALUE) {
                LOG.error("Too many child buses");
            }
            childOrder.set(childOrder.size() - 1, lastChildIndex + 1);
        } while (this.myChildOrders.putIfAbsent(childOrder, Boolean.TRUE) != null);
        childBus.myOrderRef.set(childOrder);
        this.myChildBuses.add(childBus);
        this.rootBus().clearSubscriberCache();
    }

    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed = this.myChildBuses.remove(childBus);
        this.myChildOrders.remove(childBus.myOrderRef.get());
        Map map = (Map)this.getRootBus().myWaitingBuses.get();
        if (map != null) {
            map.remove(childBus);
        }
        this.rootBus().clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        MessageBusConnection messageBusConnection = this.connect(this.myConnectionDisposable);
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        return messageBusConnection;
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "connect"));
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        this.checkNotDisposed();
        Object publisher = this.mySyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.mySyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "syncPublisher"));
        }
        return (L)v;
    }

    @Override
    @NotNull
    public <L> L asyncPublisher(final @NotNull Topic<L> topic) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/util/messages/impl/MessageBusImpl", "asyncPublisher"));
        }
        this.checkNotDisposed();
        Object publisher = this.myAsyncPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    MessageBusImpl.this.postMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myAsyncPublishers, topic, publisher);
        }
        Object v = publisher;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "asyncPublisher"));
        }
        return (L)v;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        for (MessageBusImpl childBus : this.myChildBuses) {
            childBus.dispose();
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
        this.myDisposed = true;
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/util/messages/impl/MessageBusImpl", "hasUndeliveredEvents"));
        }
        if (!this.isDispatchingAnything()) {
            return false;
        }
        for (MessageBusConnectionImpl connection : this.getTopicSubscribers(topic)) {
            if (!connection.containsMessage(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isDispatchingAnything() {
        return this.getRootBus().myWaitingBuses.get() != null;
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result) {
        Topic.BroadcastDirection direction;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result);
        }
    }

    private void postMessage(Message message) {
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(Topic topic) {
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        SmartList<MessageBusConnectionImpl> smartList = topicSubscribers;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "getTopicSubscribers"));
        }
        return smartList;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map == null) {
            map = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map);
        }
        if ((newCount = (count = (countObject = (Integer)map.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map.put(this, newCount);
        } else if (newCount == 0) {
            map.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            List<MessageBusImpl> buses;
            final Map map = (Map)this.asRoot().myWaitingBuses.get();
            if (map != null && !(buses = ContainerUtil.filter(map.keySet(), new Condition<MessageBusImpl>(){

                @Override
                public boolean value(MessageBusImpl bus) {
                    return MessageBusImpl.ensureAlive(map, bus);
                }
            })).isEmpty()) {
                MessageBusImpl.pumpWaitingBuses(buses);
            }
        }
    }

    private static void pumpWaitingBuses(List<MessageBusImpl> buses) {
        List<Throwable> exceptions = null;
        for (MessageBusImpl bus : buses) {
            if (bus.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, bus.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(List<Throwable> exceptions, List<Throwable> busExceptions) {
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList<Throwable>();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(List<Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(Map<MessageBusImpl, Integer> map, MessageBusImpl bus) {
        if (bus.myDisposed) {
            map.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        SmartList<Throwable> exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/util/messages/impl/MessageBusImpl", "notifyOnSubscription"));
        }
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/util/messages/impl/MessageBusImpl", "notifyOnSubscription"));
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.rootBus().clearSubscriberCache();
    }

    private void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.rootBus().clearSubscriberCache();
        Iterator i2 = this.myMessageQueue.get().iterator();
        while (i2.hasNext()) {
            DeliveryJob job = (DeliveryJob)i2.next();
            if (job.connection != connection) continue;
            i2.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal threadLocal = new ThreadLocal<Queue<T>>(){

            @Override
            protected Queue<T> initialValue() {
                return new ConcurrentLinkedQueue();
            }
        };
        if (threadLocal == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/impl/MessageBusImpl", "createThreadLocalQueue"));
        }
        return threadLocal;
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;

        public RootBus(@NotNull Object owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        public DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }
    }
}

