/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

class RemoveLeadingZeroFix
extends InspectionGadgetsFix {
    RemoveLeadingZeroFix() {
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("remove.leading.zero.to.make.decimal.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/RemoveLeadingZeroFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        int index;
        PsiLiteralExpression literal = (PsiLiteralExpression)descriptor.getPsiElement();
        String text2 = literal.getText();
        int max = text2.length() - (PsiType.LONG.equals(literal.getType()) ? 2 : 1);
        if (max < 1) {
            return;
        }
        for (index = 0; index < max && (text2.charAt(index) == '0' || text2.charAt(index) == '_'); ++index) {
        }
        String textWithoutLeadingZeros = text2.substring(index);
        PsiReplacementUtil.replaceExpression(literal, textWithoutLeadingZeros);
    }
}

