/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectHighlightsUtil {
    public static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create("com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil");
    private static final int STARTING_TREE_HEIGHT = 100;

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsInRange"));
        }
        List<PsiElement> list = CollectHighlightsUtil.getElementsInRange(root, startOffset, endOffset, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsInRange"));
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root, int startOffset, int endOffset, boolean includeAllParents) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsInRange"));
        }
        PsiElement commonParent = CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset);
        if (commonParent == null) {
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsInRange"));
            }
            return arrayList;
        }
        List<PsiElement> list = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent = commonParent;
        while (parent != null && parent != root) {
            list.add(parent);
            parent = includeAllParents ? parent.getParent() : null;
        }
        list.add(root);
        List<PsiElement> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsInRange"));
        }
        return list2;
    }

    @NotNull
    private static List<PsiElement> getElementsToHighlight(@NotNull PsiElement parent, int startOffset, int endOffset) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsToHighlight"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        int currentOffset = parent.getTextRange().getStartOffset();
        Condition<PsiElement>[] filters = Extensions.getExtensions(EP_NAME);
        int offset = currentOffset;
        TIntStack starts = new TIntStack(100);
        Stack<PsiElement> elements = new Stack<PsiElement>(100);
        Stack<PsiElement> children = new Stack<PsiElement>(100);
        PsiElement element = parent;
        PsiElement child = PsiUtilCore.NULL_PSI_ELEMENT;
        while (true) {
            boolean startChildrenVisiting;
            ProgressIndicatorProvider.checkCanceled();
            for (Condition<PsiElement> filter : filters) {
                if (filter.value(element)) continue;
                assert (child == PsiUtilCore.NULL_PSI_ELEMENT);
                child = null;
                break;
            }
            if (child == PsiUtilCore.NULL_PSI_ELEMENT) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (elements.isEmpty()) break;
                int start = starts.pop();
                if (startOffset <= start && offset <= endOffset) {
                    assert (element != null);
                    assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
                    result.add(element);
                }
                element = (PsiElement)elements.pop();
                child = (PsiElement)children.pop();
                continue;
            }
            if (offset > endOffset) break;
            children.push(child.getNextSibling());
            starts.push(offset);
            assert (element != null);
            assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
            elements.push(element);
            element = child;
            child = PsiUtilCore.NULL_PSI_ELEMENT;
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil", "getElementsToHighlight"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(left, right);
        if (commonParent == null) {
            LOG.error("No common parent for " + left + " and " + right + "; root: " + root + "; startOffset: " + startOffset + "; endOffset: " + endOffset);
        }
        LOG.assertTrue(commonParent.getTextRange() != null, commonParent);
        for (PsiElement parent = commonParent.getParent(); parent != null && commonParent.getTextRange().equals(parent.getTextRange()); parent = parent.getParent()) {
            commonParent = parent;
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root, int offset) {
        if (root instanceof PsiFile) {
            return ((PsiFile)root).getViewProvider().findElementAt(offset, root.getLanguage());
        }
        return root.findElementAt(offset);
    }
}

