/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectorMatchingEndFinder {
    public static int findMatchingEnd(@NotNull String startSymbol, @NotNull String endSymbol, @NotNull String text2, int afterStartIdx) {
        if (startSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findMatchingEnd"));
        }
        if (endSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findMatchingEnd"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findMatchingEnd"));
        }
        if (afterStartIdx < 0) {
            return -1;
        }
        Character shortStartSymbol = InjectorMatchingEndFinder.defineShortSymbol(startSymbol);
        Character shortEndSymbol = InjectorMatchingEndFinder.defineShortSymbol(endSymbol);
        if (shortStartSymbol != null || shortEndSymbol != null) {
            return InjectorMatchingEndFinder.findForShortSymbols(InjectorMatchingEndFinder.nonNullifyShortSymbol(shortStartSymbol, startSymbol), InjectorMatchingEndFinder.nonNullifyShortSymbol(shortEndSymbol, endSymbol), text2, afterStartIdx, endSymbol);
        }
        return InjectorMatchingEndFinder.findForLongSymbols(text2, afterStartIdx, startSymbol, endSymbol);
    }

    private static char nonNullifyShortSymbol(@Nullable Character shortStartSymbol, @NotNull String startSymbol) {
        if (startSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "nonNullifyShortSymbol"));
        }
        return shortStartSymbol == null ? startSymbol.charAt(0) : shortStartSymbol.charValue();
    }

    private static Character defineShortSymbol(String s) {
        if (s.length() == 2 && s.charAt(0) == s.charAt(1)) {
            return Character.valueOf(s.charAt(0));
        }
        return null;
    }

    private static int findForShortSymbols(char shortStartSymbol, char shortEndSymbol, @NotNull String text2, int afterStartIdx, @NotNull String endSymbol) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findForShortSymbols"));
        }
        if (endSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findForShortSymbols"));
        }
        int lookFrom = afterStartIdx;
        for (int totalNumStarts = 1; totalNumStarts > 0; --totalNumStarts) {
            int nextEndIdx = text2.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text2, lookFrom, nextEndIdx, shortStartSymbol);
            int numEnds = InjectorMatchingEndFinder.getOccurrenceCount(text2, lookFrom, nextEndIdx, shortEndSymbol);
            lookFrom = nextEndIdx + 1;
            if ((totalNumStarts += numStarts - numEnds) > 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    private static int findForLongSymbols(@NotNull String text2, int afterStartIdx, @NotNull String startSymbol, @NotNull String endSymbol) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findForLongSymbols"));
        }
        if (startSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findForLongSymbols"));
        }
        if (endSymbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endSymbol", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "findForLongSymbols"));
        }
        int totalNumStarts = 1;
        int lookFrom = afterStartIdx;
        while (totalNumStarts > 0) {
            --totalNumStarts;
            int nextEndIdx = text2.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text2, lookFrom, nextEndIdx, startSymbol);
            if (numStarts > 0) {
                totalNumStarts += numStarts;
            }
            lookFrom = nextEndIdx + endSymbol.length();
            if (totalNumStarts != 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text2, int from, int toExcluding, char c) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "getOccurrenceCount"));
        }
        int res = 0;
        int i2 = from;
        int limit = Math.min(text2.length(), toExcluding);
        while (i2 < limit && (i2 = text2.indexOf(c, i2)) >= 0 && i2 < limit) {
            ++res;
            ++i2;
        }
        return res;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text2, int from, int toExcluding, String s) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/InjectorMatchingEndFinder", "getOccurrenceCount"));
        }
        int res = 0;
        int i2 = from;
        int limit = Math.min(text2.length(), toExcluding);
        while (i2 < limit && (i2 = text2.indexOf(s, i2)) >= 0 && i2 < limit) {
            ++res;
            i2 += s.length();
        }
        return res;
    }
}

