/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteImportFix;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public class JavaLangImportInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("java.lang.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/JavaLangImportInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("java.lang.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/JavaLangImportInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteImportFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JavaLangImportVisitor();
    }

    private static class JavaLangImportVisitor
    extends BaseInspectionVisitor {
        private JavaLangImportVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass) {
            PsiImportStatement[] importStatements;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/imports/JavaLangImportInspection$JavaLangImportVisitor", "visitClass"));
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getContainingFile();
            if (!file.getClasses()[0].equals(aClass)) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                this.checkImportStatement(importStatement, file);
            }
        }

        private void checkImportStatement(PsiImportStatement importStatement, PsiJavaFile file) {
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            if (reference == null) {
                return;
            }
            String text2 = importStatement.getQualifiedName();
            if (text2 == null) {
                return;
            }
            if (importStatement.isOnDemand()) {
                if ("java.lang".equals(text2)) {
                    this.registerError((PsiElement)importStatement, new Object[0]);
                }
            } else {
                int classNameIndex = text2.lastIndexOf(46);
                if (classNameIndex < 0) {
                    return;
                }
                String parentName = text2.substring(0, classNameIndex);
                if (!"java.lang".equals(parentName)) {
                    return;
                }
                if (ImportUtils.hasOnDemandImportConflict(text2, file)) {
                    return;
                }
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }
}

