/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.search.LocalSearchScope");
    @NotNull
    private final PsiElement[] myScope;
    private final VirtualFile[] myVirtualFiles;
    private final boolean myIgnoreInjectedPsi;
    public static final LocalSearchScope EMPTY = new LocalSearchScope(PsiElement.EMPTY_ARRAY);
    private String myDisplayName;

    public LocalSearchScope(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement scope, @Nullable String displayName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(new PsiElement[]{scope});
        this.myDisplayName = displayName;
    }

    public LocalSearchScope(@NotNull PsiElement[] scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement[] scope, @Nullable String displayName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this(scope, displayName, false);
    }

    public LocalSearchScope(@NotNull PsiElement[] scope, @Nullable String displayName, boolean ignoreInjectedPsi) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "<init>"));
        }
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
        this.myDisplayName = displayName;
        LinkedHashSet<PsiElement> localScope = new LinkedHashSet<PsiElement>(scope.length);
        THashSet virtualFiles = new THashSet(scope.length);
        for (PsiElement element : scope) {
            VirtualFile virtualFile;
            LOG.assertTrue(element != null, "null element");
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null, element.getClass().getName());
            if (element instanceof PsiFile) {
                for (PsiFile file : ((PsiFile)element).getViewProvider().getAllFiles()) {
                    if (file == null) {
                        throw new IllegalArgumentException("file " + element + " returned null in its getAllFiles()");
                    }
                    localScope.add(file);
                }
            } else if (element instanceof StubBasedPsiElement || element.getTextRange() != null) {
                localScope.add(element);
            }
            if ((virtualFile = PsiUtilCore.getVirtualFile(containingFile)) == null) continue;
            virtualFiles.add(virtualFile);
        }
        this.myScope = PsiUtilCore.toPsiElementArray(localScope);
        this.myVirtualFiles = VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)virtualFiles);
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName == null ? super.getDisplayName() : this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElement[] getScope() {
        if (this.myScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "getScope"));
        }
        return this.myScope;
    }

    @NotNull
    public VirtualFile[] getVirtualFiles() {
        if (this.myVirtualFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "getVirtualFiles"));
        }
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalSearchScope)) {
            return false;
        }
        LocalSearchScope other = (LocalSearchScope)o;
        if (other.myIgnoreInjectedPsi != this.myIgnoreInjectedPsi) {
            return false;
        }
        if (other.myScope.length != this.myScope.length) {
            return false;
        }
        if (!Comparing.strEqual(this.myDisplayName, other.myDisplayName)) {
            return false;
        }
        for (PsiElement scopeElement : this.myScope) {
            for (PsiElement thatScopeElement : other.myScope) {
                if (Comparing.equal(scopeElement, thatScopeElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        result += this.myIgnoreInjectedPsi ? 1 : 0;
        for (PsiElement element : this.myScope) {
            result += element.hashCode();
        }
        return result;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.intersection(this, scope2);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        return localSearchScope;
    }

    @NotNull
    private static LocalSearchScope intersection(@NotNull LocalSearchScope scope1, @NotNull LocalSearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope1", "com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element1 : scope1.myScope) {
            for (PsiElement element2 : scope2.myScope) {
                PsiElement element = LocalSearchScope.intersectScopeElements(element1, element2);
                if (element == null) continue;
                result.add(element);
            }
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), null, scope1.myIgnoreInjectedPsi || scope2.myIgnoreInjectedPsi);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersection"));
        }
        return localSearchScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope = this.intersectWith((LocalSearchScope)scope2);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        LocalSearchScope nonPhysicalScope = this.tryIntersectNonPhysicalWith((GlobalSearchScope)scope2);
        if (nonPhysicalScope != null) {
            LocalSearchScope localSearchScope = nonPhysicalScope;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
            }
            return localSearchScope;
        }
        SearchScope searchScope = ((GlobalSearchScope)scope2).intersectWith(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "intersectWith"));
        }
        return searchScope;
    }

    @Nullable
    private LocalSearchScope tryIntersectNonPhysicalWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "tryIntersectNonPhysicalWith"));
        }
        Project project = scope.getProject();
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            if (containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            if (project == null || project == containingFile.getProject()) continue;
            return EMPTY;
        }
        return this;
    }

    @Nullable
    private static PsiElement intersectScopeElements(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/search/LocalSearchScope", "intersectScopeElements"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/search/LocalSearchScope", "intersectScopeElements"));
        }
        if (PsiTreeUtil.isContextAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isContextAncestor(element2, element1, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element1;
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.myScope.length; ++i) {
            PsiElement element = this.myScope[i];
            if (i > 0) {
                result.append(",");
            }
            result.append(element);
        }
        return "LocalSearchScope:" + result;
    }

    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "union"));
        }
        if (scope instanceof LocalSearchScope) {
            SearchScope searchScope = this.union((LocalSearchScope)scope);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "union"));
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = ((GlobalSearchScope)scope).union(this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "union"));
        }
        return globalSearchScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/LocalSearchScope", "contains"));
        }
        return this.isInScope(file);
    }

    @NotNull
    public SearchScope union(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/LocalSearchScope", "union"));
        }
        if (this.equals(scope2)) {
            LocalSearchScope localSearchScope = this;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "union"));
            }
            return localSearchScope;
        }
        PsiElement[] elements1 = this.getScope();
        PsiElement[] elements2 = scope2.getScope();
        boolean[] united = new boolean[elements2.length];
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (PsiElement element1 : elements1) {
            for (int j = 0; j < elements2.length; ++j) {
                PsiElement element2 = elements2[j];
                PsiElement unionElement = LocalSearchScope.scopeElementsUnion(element1, element2);
                if (unionElement == null || unionElement.getContainingFile() == null) continue;
                result.add(unionElement);
                united[j] = true;
                break block0;
            }
            result.add(element1);
        }
        for (int i = 0; i < united.length; ++i) {
            boolean b = united[i];
            if (b) continue;
            result.add(elements2[i]);
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(PsiUtilCore.toPsiElementArray(result));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "union"));
        }
        return localSearchScope;
    }

    private static PsiElement scopeElementsUnion(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/search/LocalSearchScope", "scopeElementsUnion"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/search/LocalSearchScope", "scopeElementsUnion"));
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element2;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        if (commonParent == null) {
            return null;
        }
        return commonParent;
    }

    public boolean isInScope(VirtualFile file) {
        return ArrayUtil.indexOf(this.myVirtualFiles, file) != -1;
    }

    public boolean containsRange(PsiFile file, @NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/search/LocalSearchScope", "containsRange"));
        }
        for (PsiElement element : this.getScope()) {
            if (file != element.getContainingFile() || !element.getTextRange().contains(range)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static LocalSearchScope getScopeRestrictedByFileTypes(@NotNull LocalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        if (scope == EMPTY) {
            LocalSearchScope localSearchScope = EMPTY;
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = ReadAction.compute(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/LocalSearchScope", "lambda$getScopeRestrictedByFileTypes$0"));
            }
            if (fileTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/psi/search/LocalSearchScope", "lambda$getScopeRestrictedByFileTypes$0"));
            }
            PsiElement[] elements = scope.getScope();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements.length);
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                FileType fileType = containingFile.getFileType();
                if (!ArrayUtil.contains(fileType, fileTypes)) continue;
                result.add(element);
            }
            return result.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/LocalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        return localSearchScope;
    }
}

