/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

abstract class ThreadLocalAnnotatorMap<K, V> {
    private volatile int version;
    private final ThreadLocal<VersionedMap<K, V>> CACHE = new ThreadLocal<VersionedMap<K, V>>(){

        @Override
        protected VersionedMap<K, V> initialValue() {
            return new VersionedMap(ThreadLocalAnnotatorMap.this.version);
        }
    };

    ThreadLocalAnnotatorMap() {
    }

    @NotNull
    public abstract Collection<V> initialValue(@NotNull K var1);

    @NotNull
    private List<V> cloneTemplates(@NotNull Collection<V> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        ArrayList<Object> result = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (V template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new CachingConstructorInjectionComponentAdapter(aClass.getName(), aClass).getComponentInstance(container);
            result.add(clone);
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        return arrayList;
    }

    @NotNull
    public List<V> get(@NotNull K key) {
        List<V> cached;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        VersionedMap<K, V> map = this.CACHE.get();
        if (this.version != ((VersionedMap)map).version) {
            this.CACHE.remove();
            map = this.CACHE.get();
        }
        if ((cached = (List<V>)map.get(key)) == null) {
            Collection<V> templates = this.initialValue(key);
            cached = this.cloneTemplates(templates);
            map.put(key, cached);
        }
        List<V> list = cached;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        return list;
    }

    public void clear() {
        ++this.version;
    }

    private static class VersionedMap<K, V>
    extends THashMap<K, List<V>> {
        private final int version;

        private VersionedMap(int version) {
            this.version = version;
        }
    }
}

