/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllOccurrencesMatcher
extends FixingLayoutMatcher {
    public AllOccurrencesMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/codeStyle/AllOccurrencesMatcher", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/codeStyle/AllOccurrencesMatcher", "<init>"));
        }
        super(pattern, options, hardSeparators);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/codeStyle/AllOccurrencesMatcher", "matchingFragments"));
        }
        FList<TextRange> match = super.matchingFragments(name);
        if (!ContainerUtil.isEmpty(match)) {
            ArrayList<FList<TextRange>> allMatchesReversed = new ArrayList<FList<TextRange>>();
            int lastOffset = 0;
            while (!ContainerUtil.isEmpty(match)) {
                FList<TextRange> reversedWithAbsoluteOffsets = FList.emptyList();
                for (TextRange r : match) {
                    reversedWithAbsoluteOffsets = reversedWithAbsoluteOffsets.prepend(r.shiftRight(lastOffset));
                }
                allMatchesReversed.add(reversedWithAbsoluteOffsets);
                lastOffset = ((TextRange)reversedWithAbsoluteOffsets.get(0)).getEndOffset();
                match = super.matchingFragments(name.substring(lastOffset));
            }
            match = FList.emptyList();
            for (int i2 = allMatchesReversed.size() - 1; i2 >= 0; --i2) {
                for (TextRange range : (FList)allMatchesReversed.get(i2)) {
                    match = match.prepend(range);
                }
            }
        }
        return match;
    }
}

