/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.containers.Predicate;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class LazyConcurrentCollection<T, V>
implements Iterable<V> {
    private final HashSetQueue<T> subClasses;
    private final Object lock;
    @NotNull
    private final Function<T, V> myAnchorToValueConvertor;
    @NotNull
    private final MoreElementsGenerator<T, V> myGenerator;
    @NotNull
    private final Predicate<? super V> myApplicableForGenerationFilter;
    private final Semaphore currentlyProcessingClasses;
    private final HashSetQueue.PositionalIterator<T> candidatesToFindSubclassesIterator;
    private final Set<T> classesBeingProcessed;
    private final Set<T> classesProcessed;

    LazyConcurrentCollection(@NotNull T seedElement, @NotNull Function<T, V> convertor, @NotNull Predicate<? super V> applicableForGenerationFilter, @NotNull MoreElementsGenerator<T, V> generator) {
        if (seedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seedElement", "com/intellij/psi/impl/search/LazyConcurrentCollection", "<init>"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/psi/impl/search/LazyConcurrentCollection", "<init>"));
        }
        if (applicableForGenerationFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableForGenerationFilter", "com/intellij/psi/impl/search/LazyConcurrentCollection", "<init>"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/psi/impl/search/LazyConcurrentCollection", "<init>"));
        }
        this.lock = new Object();
        this.currentlyProcessingClasses = new Semaphore();
        this.classesBeingProcessed = new THashSet();
        this.classesProcessed = new THashSet();
        this.subClasses = new HashSetQueue();
        this.subClasses.add(seedElement);
        this.myAnchorToValueConvertor = convertor;
        this.myGenerator = generator;
        this.myApplicableForGenerationFilter = applicableForGenerationFilter;
        this.candidatesToFindSubclassesIterator = this.subClasses.iterator();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        Iterator iterator = new Iterator<V>(){
            private final Iterator<T> subClassIterator;
            {
                this.subClassIterator = LazyConcurrentCollection.this.subClasses.iterator();
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    this.subClassIterator.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    if (this.subClassIterator.hasNext()) {
                        return true;
                    }
                }
                LazyConcurrentCollection.this.processMoreSubclasses(this.subClassIterator);
                object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    return this.subClassIterator.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V next() {
                Object next;
                Object object = LazyConcurrentCollection.this.lock;
                synchronized (object) {
                    next = this.subClassIterator.next();
                }
                return LazyConcurrentCollection.this.myAnchorToValueConvertor.fun(next);
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/LazyConcurrentCollection", "iterator"));
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMoreSubclasses(@NotNull Iterator<T> subClassIterator) {
        if (subClassIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClassIterator", "com/intellij/psi/impl/search/LazyConcurrentCollection", "processMoreSubclasses"));
        }
        while (true) {
            ProgressManager.checkCanceled();
            Pair.NonNull pair = ReadAction.compute(() -> {
                Object object = this.lock;
                synchronized (object) {
                    Pair.NonNull<T, V> next;
                    HashSetQueue.PositionalIterator.IteratorPosition<T> startPosition = this.candidatesToFindSubclassesIterator.position().next();
                    Pair.NonNull<T, V> nonNull = next = startPosition == null ? null : this.findNextClassInQueue(startPosition);
                    if (next != null) {
                        this.currentlyProcessingClasses.down();
                        this.classesBeingProcessed.add(next.getFirst());
                    }
                    return next;
                }
            });
            if (pair == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.advanceIteratorOnSuccess();
                    if (subClassIterator.hasNext()) {
                        return true;
                    }
                }
                boolean producedSomething = this.waitForOtherThreadsToFinishProcessing(subClassIterator);
                if (producedSomething) {
                    return true;
                }
                Object object2 = this.lock;
                synchronized (object2) {
                    this.advanceIteratorOnSuccess();
                    if (!this.candidatesToFindSubclassesIterator.hasNext()) {
                        return false;
                    }
                }
            }
            Object candidate = pair.getSecond();
            Object anchor = pair.getFirst();
            try {
                this.myGenerator.generateMoreElementsFor(candidate, generatedElement -> {
                    Object object = this.lock;
                    synchronized (object) {
                        this.subClasses.add(generatedElement);
                    }
                });
                Object object = this.lock;
                synchronized (object) {
                    block29: {
                        this.classesProcessed.add(anchor);
                        this.advanceIteratorOnSuccess();
                        if (!subClassIterator.hasNext()) break block29;
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                }
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.classesBeingProcessed.remove(anchor);
                    this.currentlyProcessingClasses.up();
                }
                continue;
            }
            break;
        }
    }

    private boolean waitForOtherThreadsToFinishProcessing(final @NotNull Iterator<T> subClassIterator) {
        if (subClassIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClassIterator", "com/intellij/psi/impl/search/LazyConcurrentCollection", "waitForOtherThreadsToFinishProcessing"));
        }
        final AtomicBoolean hasNext = new AtomicBoolean();
        try {
            ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                @Override
                public boolean block() throws InterruptedException {
                    LazyConcurrentCollection.this.currentlyProcessingClasses.waitFor();
                    return this.isReleasable();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isReleasable() {
                    Object object = LazyConcurrentCollection.this.lock;
                    synchronized (object) {
                        boolean producedSomething = subClassIterator.hasNext();
                        hasNext.set(producedSomething);
                        return producedSomething || !LazyConcurrentCollection.this.candidatesToFindSubclassesIterator.hasNext() || LazyConcurrentCollection.this.classesBeingProcessed.isEmpty();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return hasNext.get();
    }

    private Pair.NonNull<T, V> findNextClassInQueue(@NotNull HashSetQueue.PositionalIterator.IteratorPosition<T> position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/search/LazyConcurrentCollection", "findNextClassInQueue"));
        }
        while (position != null) {
            ProgressManager.checkCanceled();
            T anchor = position.peek();
            if (!this.classesProcessed.contains(anchor) && !this.classesBeingProcessed.contains(anchor)) {
                boolean isAccepted;
                V value = this.myAnchorToValueConvertor.fun(anchor);
                boolean bl = isAccepted = value != null && this.myApplicableForGenerationFilter.apply(value);
                if (isAccepted) {
                    return Pair.createNonNull(anchor, value);
                }
                this.classesProcessed.add(anchor);
            }
            position = position.next();
        }
        return null;
    }

    private void advanceIteratorOnSuccess() {
        T next;
        boolean removed;
        while (this.candidatesToFindSubclassesIterator.hasNext() && (removed = this.classesProcessed.remove(next = this.candidatesToFindSubclassesIterator.position().next().peek()))) {
            this.candidatesToFindSubclassesIterator.next();
        }
    }

    @FunctionalInterface
    static interface MoreElementsGenerator<T, V> {
        public void generateMoreElementsFor(@NotNull V var1, @NotNull Consumer<T> var2);
    }
}

