/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementDecrementUsedAsExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ValueOfIncrementOrDecrementUsed" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "getID"));
        }
        return "ValueOfIncrementOrDecrementUsed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("increment.decrement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)info;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
                String string = InspectionGadgetsBundle.message("value.of.post.increment.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("value.of.post.decrement.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "buildErrorString"));
            }
            return string;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
            String string = InspectionGadgetsBundle.message("value.of.pre.increment.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("value.of.pre.decrement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, PsiCodeBlock.class, true, PsiMember.class) == null) {
            return null;
        }
        return new IncrementDecrementUsedAsExpressionFix(expression.getText());
    }

    public static void extractPrefixPostfixExpressionToSeparateStatement(PsiElement element) {
        SearchScope useScope;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        PsiExpression operand;
        if (element instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
            operand = postfixExpression.getOperand();
        } else if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            operand = prefixExpression.getOperand();
        } else {
            assert (false);
            return;
        }
        if (operand == null) {
            return;
        }
        PsiStatement statement = PsiTreeUtil.getParentOfType(element, PsiStatement.class);
        if (statement == null) {
            return;
        }
        PsiElement parent = statement.getParent();
        if (parent == null) {
            return;
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        String newStatementText = element.getText() + ';';
        String operandText = operand.getText();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement) {
            StringBuilder text2 = new StringBuilder();
            text2.append('{');
            String elementText = PsiReplacementUtil.getElementText(statement, element, operandText);
            if (element instanceof PsiPostfixExpression) {
                text2.append(elementText);
                text2.append(newStatementText);
            } else {
                text2.append(newStatementText);
                text2.append(elementText);
            }
            text2.append('}');
            PsiCodeBlock codeBlock = factory.createCodeBlockFromText(text2.toString(), parent);
            statement.replace(codeBlock);
            return;
        }
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
        if (statement instanceof PsiReturnStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("result", (PsiElement)returnValue, true);
                PsiType type = returnValue.getType();
                if (type == null) {
                    return;
                }
                String newReturnValueText = PsiReplacementUtil.getElementText(returnValue, element, operandText);
                String declarationStatementText = type.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, returnStatement);
                parent.addBefore(declarationStatement, statement);
                parent.addBefore(newStatement, statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("return " + variableName + ';', returnStatement);
                returnStatement.replace(newReturnStatement);
                return;
            }
            parent.addBefore(newStatement, statement);
        } else if (statement instanceof PsiThrowStatement) {
            if (element instanceof PsiPostfixExpression) {
                PsiThrowStatement returnStatement = (PsiThrowStatement)statement;
                PsiExpression exception = returnStatement.getException();
                if (exception == null) {
                    return;
                }
                JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
                String variableName = javaCodeStyleManager.suggestUniqueVariableName("e", (PsiElement)exception, true);
                PsiType type = exception.getType();
                if (type == null) {
                    return;
                }
                String newReturnValueText = PsiReplacementUtil.getElementText(exception, element, operandText);
                String declarationStatementText = type.getCanonicalText() + ' ' + variableName + '=' + newReturnValueText + ';';
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, returnStatement);
                parent.addBefore(declarationStatement, statement);
                parent.addBefore(newStatement, statement);
                PsiStatement newReturnStatement = factory.createStatementFromText("throw " + variableName + ';', returnStatement);
                returnStatement.replace(newReturnStatement);
                return;
            }
            parent.addBefore(newStatement, statement);
        } else if (!(statement instanceof PsiForStatement)) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter(newStatement, statement);
            } else {
                parent.addBefore(newStatement, statement);
            }
        } else if (operand instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)operand).resolve()) != null && !new LocalSearchScope(statement).equals(useScope = target.getUseScope())) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter(newStatement, statement);
            } else {
                parent.addBefore(newStatement, statement);
            }
        }
        if (statement instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
            PsiStatement body = loopStatement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (element instanceof PsiPostfixExpression) {
                    PsiElement firstElement = codeBlock.getFirstBodyElement();
                    codeBlock.addBefore(newStatement, firstElement);
                } else {
                    codeBlock.add(newStatement);
                }
            } else {
                StringBuilder blockText = new StringBuilder();
                blockText.append('{');
                if (element instanceof PsiPostfixExpression) {
                    blockText.append(newStatementText);
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                } else {
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                    blockText.append(newStatementText);
                }
                blockText.append('}');
                PsiStatement blockStatement = factory.createStatementFromText(blockText.toString(), statement);
                if (body == null) {
                    loopStatement.add(blockStatement);
                } else {
                    body.replace(blockStatement);
                }
            }
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)element, operandText);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncrementDecrementUsedAsExpressionVisitor();
    }

    private static class IncrementDecrementUsedAsExpressionVisitor
    extends BaseInspectionVisitor {
        private IncrementDecrementUsedAsExpressionVisitor() {
        }

        @Override
        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionVisitor", "visitPostfixExpression"));
            }
            super.visitPostfixExpression(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        @Override
        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionVisitor", "visitPrefixExpression"));
            }
            super.visitPrefixExpression(expression);
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }
    }

    private static class IncrementDecrementUsedAsExpressionFix
    extends InspectionGadgetsFix {
        private final String elementText;

        IncrementDecrementUsedAsExpressionFix(String elementText) {
            this.elementText = elementText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("increment.decrement.used.as.expression.quickfix", this.elementText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Extract to separate statement" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionFix", "getFamilyName"));
            }
            return "Extract to separate statement";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            IncrementDecrementUsedAsExpressionInspection.extractPrefixPostfixExpressionToSeparateStatement(descriptor.getPsiElement());
        }
    }
}

