/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "getExcludedRoots"));
        }
        return set;
    }

    @Nullable
    public Condition<CharSequence> getExcludeCondition() {
        return null;
    }

    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        Condition<CharSequence> condition = this.getExcludeCondition();
        return condition != null ? f -> condition.value(f.getNameSequence()) : null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(@NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, Collections.emptySet(), null);
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @NotNull Collection<VirtualFile> sourceRoots, final @NotNull Set<VirtualFile> excludedRoots, final @Nullable Condition<VirtualFile> excludeCondition) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        if (excludedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getSourceRoots"));
                }
                return collection;
            }

            @Override
            @NotNull
            public Set<VirtualFile> getExcludedRoots() {
                Set set = excludedRoots;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getExcludedRoots"));
                }
                return set;
            }

            @Override
            @Nullable
            public Condition<VirtualFile> getExcludeFileCondition() {
                return excludeCondition;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SyntheticLibrary library = (SyntheticLibrary)o;
                if (!sourceRoots.equals(library.getSourceRoots())) {
                    return false;
                }
                if (!excludedRoots.equals(library.getExcludedRoots())) {
                    return false;
                }
                return !(excludeCondition != null ? !excludeCondition.equals(library.getExcludeFileCondition()) : library.getExcludeFileCondition() != null);
            }

            @Override
            public int hashCode() {
                int result = sourceRoots.hashCode();
                result = 31 * result + excludedRoots.hashCode();
                result = 31 * result + (excludeCondition != null ? excludeCondition.hashCode() : 0);
                return result;
            }
        };
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }
}

