/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean condition = (Boolean)infos[0];
        boolean update = (Boolean)infos[1];
        if (condition && update) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
            }
            return string;
        }
        if (condition) {
            String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement) {
            boolean notUsedInUpdate;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/ForLoopThatDoesntUseLoopVariableInspection$ForLoopThatDoesntUseLoopVariableVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement);
            PsiLocalVariable variable = ForLoopThatDoesntUseLoopVariableVisitor.extractInitializerVariable(statement);
            if (variable == null) {
                return;
            }
            boolean notUsedInCondition = !ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesVariable(statement, variable);
            boolean bl = notUsedInUpdate = !ForLoopThatDoesntUseLoopVariableVisitor.updateUsesVariable(statement, variable);
            if (notUsedInCondition || notUsedInUpdate) {
                if (!notUsedInCondition && ForLoopThatDoesntUseLoopVariableVisitor.isDeclarationUsedAsBound(statement, variable)) {
                    return;
                }
                this.registerStatementError(statement, notUsedInCondition, notUsedInUpdate);
            }
        }

        private static boolean isDeclarationUsedAsBound(PsiForStatement statement, PsiLocalVariable boundVar) {
            PsiBinaryExpression condition = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(statement.getCondition()), PsiBinaryExpression.class);
            if (condition == null || !ComparisonUtils.isComparisonOperation(condition.getOperationTokenType())) {
                return false;
            }
            PsiExpression otherOperand = null;
            if (ExpressionUtils.isReferenceTo(condition.getLOperand(), boundVar)) {
                otherOperand = condition.getROperand();
            } else if (ExpressionUtils.isReferenceTo(condition.getROperand(), boundVar)) {
                otherOperand = condition.getLOperand();
            }
            if (otherOperand == null) {
                return false;
            }
            PsiReferenceExpression ref = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(otherOperand), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiVariable indexVar = ObjectUtils.tryCast(ref.resolve(), PsiVariable.class);
            if (indexVar == null) {
                return false;
            }
            PsiStatement update = statement.getUpdate();
            return VariableAccessUtils.variableIsIncremented(indexVar, update) || VariableAccessUtils.variableIsDecremented(indexVar, update);
        }

        private static PsiLocalVariable extractInitializerVariable(PsiForStatement statement) {
            PsiDeclarationStatement declaration = ObjectUtils.tryCast(statement.getInitialization(), PsiDeclarationStatement.class);
            if (declaration == null) {
                return null;
            }
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            return ObjectUtils.tryCast(declaredElements[0], PsiLocalVariable.class);
        }

        private static boolean conditionUsesVariable(PsiForStatement statement, PsiLocalVariable variable) {
            PsiExpression condition = statement.getCondition();
            return condition == null || VariableAccessUtils.variableIsUsed(variable, condition);
        }

        private static boolean updateUsesVariable(PsiForStatement statement, PsiLocalVariable variable) {
            PsiStatement update = statement.getUpdate();
            return update == null || VariableAccessUtils.variableIsUsed(variable, update);
        }
    }
}

