/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

class ReturnPointCountVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_count;
    private final boolean ignoreGuardClauses;
    private boolean previousWasGuardClause = true;

    ReturnPointCountVisitor(boolean ignoreGuardClauses) {
        this.ignoreGuardClauses = ignoreGuardClauses;
    }

    @Override
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/methodmetrics/ReturnPointCountVisitor", "visitAnonymousClass"));
        }
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/ReturnPointCountVisitor", "visitReturnStatement"));
        }
        super.visitReturnStatement(statement);
        if (this.ignoreGuardClauses && this.previousWasGuardClause) {
            return;
        }
        ++this.m_count;
    }

    @Override
    public void visitStatement(PsiStatement statement) {
        super.visitStatement(statement);
        if (!this.previousWasGuardClause) {
            return;
        }
        if (statement instanceof PsiDeclarationStatement) {
            return;
        }
        PsiElement parent = statement.getParent();
        if (!(parent instanceof PsiCodeBlock)) {
            return;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            return;
        }
        this.previousWasGuardClause = ReturnPointCountVisitor.isGuardClause(statement);
    }

    private static boolean isGuardClause(PsiStatement statement) {
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement;
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (thenBranch instanceof PsiReturnStatement) {
            return true;
        }
        if (!(thenBranch instanceof PsiBlockStatement)) {
            return false;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement containedStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return containedStatement instanceof PsiReturnStatement;
    }

    public int getCount() {
        return this.m_count;
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
    }

    @Override
    public void visitClass(PsiClass aClass) {
    }
}

