/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");

    private static String getPlaceholderText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getPlaceholderText"));
        }
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(((PsiMethod)element).getBody());
        }
        if (element instanceof PsiClassInitializer) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(((PsiClassInitializer)element).getBody());
        }
        if (element instanceof PsiClass || element instanceof PsiJavaModule) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(null);
        }
        if (element instanceof PsiLambdaExpression) {
            return JavaFoldingBuilderBase.getCodeBlockPlaceholder(((PsiLambdaExpression)element).getBody());
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return "<~>";
        }
        if (element instanceof PsiComment) {
            return "//...";
        }
        return "...";
    }

    private static String getCodeBlockPlaceholder(PsiElement codeBlock) {
        return codeBlock instanceof PsiCodeBlock && ((PsiCodeBlock)codeBlock).getStatements().length == 0 ? "{}" : "{...}";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        if (e1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "areOnAdjacentLines"));
        }
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method) {
        PsiExpression expr;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isSimplePropertyAccessor"));
        }
        if (DumbService.isDumb(method.getProject())) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null || body.getLBrace() == null || body.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtil.isSimplePropertySetter(method);
        }
        return false;
    }

    @Nullable
    private static TextRange getRangeToFold(@NotNull PsiElement element) {
        PsiElement body;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getRangeToFold"));
        }
        if (element instanceof SyntheticElement) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiCodeBlock body2 = ((PsiMethod)element).getBody();
            if (body2 == null) {
                return null;
            }
            return body2.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaModule) {
            PsiElement left = SyntaxTraverser.psiTraverser().children(element).find(e -> PsiUtil.isJavaToken(e, JavaTokenType.LBRACE));
            PsiElement right = SyntaxTraverser.psiTraverser().children(element).find(e -> PsiUtil.isJavaToken(e, JavaTokenType.RBRACE));
            return left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset() + 1) : null;
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilderBase.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list = (PsiImportList)element;
            PsiImportStatementBase[] statements = list.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            if (!JavaFoldingBuilderBase.hasErrorElementsNearby(element.getContainingFile(), startOffset, endOffset)) {
                return new TextRange(startOffset, endOffset);
            }
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipSiblingsForward(element, PsiWhiteSpace.class, PsiComment.class);
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        if (element instanceof PsiLambdaExpression && (body = ((PsiLambdaExpression)element).getBody()) instanceof PsiCodeBlock) {
            return body.getTextRange();
        }
        return null;
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "hasErrorElementsNearby"));
        }
        endOffset = CharArrayUtil.shiftForward(file.getViewProvider().getContents(), endOffset, " \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange(file, startOffset, endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange getFileHeader(@NotNull PsiJavaFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getFileHeader"));
        }
        PsiElement first = file.getFirstChild();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element = prevSibling;
        }
        if (element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(@Nullable PsiModifierList modifierList, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document) {
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addAnnotationsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addAnnotationsToFold"));
        }
        if (modifierList == null) {
            return;
        }
        PsiElement[] children = modifierList.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PsiElement nextChild;
            int j;
            PsiElement child = children[i];
            if (!(child instanceof PsiAnnotation)) continue;
            JavaFoldingBuilderBase.addToFold(foldElements, child, document, false);
            for (j = i + 1; j < children.length && !((nextChild = children[j]) instanceof PsiModifier); ++j) {
            }
            i = j;
        }
    }

    private static void addCommentFolds(@NotNull PsiComment comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> foldElements) {
        ASTNode node;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT || JavaFoldingBuilderBase.isCustomRegionElement(comment)) {
            return;
        }
        processedComments.add(comment);
        PsiElement end = null;
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT && !JavaFoldingBuilderBase.isCustomRegionElement(current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add(current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null) {
            foldElements.add(new FoldingDescriptor(comment, new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())));
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull PsiMethodCallExpression expression, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addMethodGenericParametersFolding"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiReferenceParameterList list = methodExpression.getParameterList();
        if (list == null || list.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 3, quick);
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "resolvesCorrectly"));
        }
        for (JavaResolveResult result : expression.multiResolve(true)) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull PsiNewExpression expression, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList list;
        PsiAnonymousClass anonymousClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addGenericParametersFolding"));
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters = ((PsiClassType)declType).getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        if (classReference == null && (anonymousClass = expression.getAnonymousClass()) != null) {
            classReference = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), anonymousClass)) {
                return;
            }
        }
        if (classReference != null && (list = classReference.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list.getText().equals(declList.getText()) : !Arrays.equals(list.getTypeArguments(), parameters)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, @NotNull PsiReferenceParameterList list, int ifLongerThan, boolean quick) {
        String text;
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addTypeParametersFolding"));
        }
        if (!quick) {
            for (PsiType type : list.getTypeArguments()) {
                if (!type.isValid()) {
                    return;
                }
                if (!(type instanceof PsiClassType) && !(type instanceof PsiArrayType) || PsiUtil.resolveClassInType(type) != null) continue;
                return;
            }
        }
        if ((text = list.getText()).startsWith("<") && text.endsWith(">") && text.length() > ifLongerThan) {
            TextRange range = list.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(foldElements, list, document, true, range);
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static void addToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        if (elementToFold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFold", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addToFold"));
        }
        PsiUtilCore.ensureValid(elementToFold);
        TextRange range = JavaFoldingBuilderBase.getRangeToFold(elementToFold);
        if (range != null) {
            JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range);
        }
    }

    private static void addFoldRegion(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (elementToFold == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFold", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addFoldRegion"));
        }
        TextRange fileRange = elementToFold.getContainingFile().getTextRange();
        if (range.equals(fileRange)) {
            return;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list.add(new FoldingDescriptor(elementToFold, range));
            }
        } else if (range.getLength() > JavaFoldingBuilderBase.getPlaceholderText(elementToFold).length()) {
            list.add(new FoldingDescriptor(elementToFold, range));
        }
    }

    @Override
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        PsiJavaModule module;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)root;
        PsiImportList importList = file.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.getRangeToFold(importList)) != null && rangeToFold.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor(importList, rangeToFold);
            descriptor.setCanBeRemovedWhenCollapsed(true);
            descriptors.add(descriptor);
        }
        if ((module = file.getModuleDeclaration()) != null) {
            JavaFoldingBuilderBase.addElementsToFold(descriptors, module, document);
        }
        PsiClass[] classes = file.getClasses();
        for (PsiClass aClass : classes) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addElementsToFold(descriptors, aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilderBase.getFileHeader(file);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiElement anchorElementToUse = file;
            PsiElement candidate = file.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals(range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            descriptors.add(new FoldingDescriptor(anchorElementToUse, range));
        }
    }

    private static void addElementsToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiJavaModule module, @NotNull Document document) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        JavaFoldingBuilderBase.addToFold(list, module, document, true);
        JavaFoldingBuilderBase.addDocCommentToFold(list, document, module);
        JavaFoldingBuilderBase.addAnnotationsToFold(module.getModifierList(), list, document);
    }

    private void addElementsToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiClass aClass, @NotNull Document document, boolean foldJavaDocs, boolean quick) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addElementsToFold"));
        }
        PsiElement parent = aClass.getParent();
        if (!(parent instanceof PsiJavaFile) || ((PsiJavaFile)parent).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list, aClass, document, true);
        }
        if (foldJavaDocs) {
            JavaFoldingBuilderBase.addDocCommentToFold(list, document, aClass);
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(aClass.getModifierList(), list, document);
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child = aClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiCodeBlock body;
                PsiMethod method = (PsiMethod)child;
                boolean oneLiner = this.addOneLineMethodFolding(list, method);
                if (!oneLiner) {
                    JavaFoldingBuilderBase.addToFold(list, method, document, true);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(method.getModifierList(), list, document);
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list, document, method);
                }
                if ((body = method.getBody()) == null || oneLiner) continue;
                this.addCodeBlockFolds(body, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list, document, field);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(field.getModifierList(), list, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds(initializer, list, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds(field, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                JavaFoldingBuilderBase.addToFold(list, child, document, true);
                this.addCodeBlockFolds(child, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addElementsToFold(list, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addCommentFolds((PsiComment)child, processedComments, list);
        }
    }

    private static void addDocCommentToFold(@NotNull List<FoldingDescriptor> list, @NotNull Document document, @NotNull PsiJavaDocumentedElement element) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addDocCommentToFold"));
        }
        PsiDocComment docComment = element.getDocComment();
        if (docComment != null) {
            JavaFoldingBuilderBase.addToFold(list, docComment, document, true);
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<FoldingDescriptor> descriptorList, @NotNull PsiMethod method) {
        if (descriptorList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorList", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addOneLineMethodFolding"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addOneLineMethodFolding"));
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods()) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body.getLBrace();
        PsiJavaToken rBrace = body.getRBrace();
        PsiStatement[] statements = body.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines(lBrace, statement, document) || !JavaFoldingBuilderBase.areOnAdjacentLines(statement, rBrace, document)) {
            return false;
        }
        int leftStart = method.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces(document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement.getTextRange().getStartOffset();
        int rightStart = statement.getTextRange().getEndOffset();
        int rightEnd = body.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin(method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup("one-liner");
        descriptorList.add(new NamedFoldingDescriptor(lBrace, leftStart, leftEnd, group, leftText));
        descriptorList.add(new NamedFoldingDescriptor(rBrace, rightStart, rightEnd, group, rightText));
        return true;
    }

    @Override
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        return JavaFoldingBuilderBase.getPlaceholderText(SourceTreeToPsiMap.treeToPsiNotNull(node));
    }

    @Override
    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isRegionCollapsedByDefault"));
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken && element.getParent() instanceof PsiAnonymousClass) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiJavaToken && element.getParent() instanceof PsiCodeBlock && element.getParent().getParent() instanceof PsiMethod) {
            return settings.isCollapseOneLineMethods();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (element instanceof PsiMethod) {
                if (!settings.isCollapseAccessors() && !settings.isCollapseMethods()) {
                    return false;
                }
                if (JavaFoldingBuilderBase.isSimplePropertyAccessor((PsiMethod)element)) {
                    return settings.isCollapseAccessors();
                }
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiJavaFile) {
                if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                    return false;
                }
                PsiElement firstChild = parent.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        if (element instanceof PsiComment) {
            return settings.isCollapseEndOfLineComments();
        }
        if (element instanceof PsiLambdaExpression) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiJavaModule) {
            return false;
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private void addCodeBlockFolds(@NotNull PsiElement scope, final @NotNull List<FoldingDescriptor> foldElements, final @NotNull Set<PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        final boolean dumb = DumbService.isDumb(scope.getProject());
        scope.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, foldElements, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(foldElements, aClass, document, true);
                    JavaFoldingBuilderBase.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(expression, foldElements, document, quick);
                }
                super.visitMethodCallExpression(expression);
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(expression, foldElements, document, quick);
                }
                super.visitNewExpression(expression);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                PsiElement body = expression.getBody();
                if (body instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(foldElements, expression, document, true);
                }
                super.visitLambdaExpression(expression);
            }

            @Override
            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addCommentFolds(comment, processedComments, foldElements);
                super.visitComment(comment);
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<FoldingDescriptor> foldElements, @NotNull Set<PsiElement> processedComments, boolean quick) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<NamedFoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<NamedFoldingDescriptor> list = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                foldElements.addAll(descriptors);
                this.addCodeBlockFolds(closureFolding.methodBody, foldElements, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        if ("->" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "rightArrow"));
        }
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "fitsRightMargin"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "fitsRightMargin"));
        }
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getProject(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull Project var1, int var2);

    @Override
    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isCustomFoldingCandidate"));
        }
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    @Override
    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isCustomFoldingRoot"));
        }
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }
}

