/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/codeInsight/navigation/MethodImplementationsSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/navigation/MethodImplementationsSearch", "execute"));
        }
        PsiElement sourceElement = queryParameters.getElement();
        if (sourceElement instanceof PsiMethod) {
            return MethodImplementationsSearch.processImplementations((PsiMethod)sourceElement, consumer, queryParameters.getScope());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean processImplementations(PsiMethod psiMethod, Processor<PsiElement> consumer, SearchScope searchScope) {
        if (!MethodImplementationsSearch.processOverridingMethods(psiMethod, searchScope, consumer::process)) return false;
        if (!FunctionalExpressionSearch.search(psiMethod, searchScope).forEach(consumer::process)) return false;
        return true;
    }

    public static void getOverridingMethods(PsiMethod method, List<PsiMethod> list, SearchScope scope) {
        MethodImplementationsSearch.processOverridingMethods(method, scope, new CommonProcessors.CollectProcessor<PsiMethod>(list));
    }

    private static boolean processOverridingMethods(PsiMethod method, SearchScope scope, Processor<PsiMethod> processor) {
        return OverridingMethodsSearch.search(method, scope, true).forEach(processor);
    }

    @Deprecated
    public static PsiMethod[] getMethodImplementations(PsiMethod method, SearchScope scope) {
        ArrayList result = new ArrayList();
        MethodImplementationsSearch.processOverridingMethods(method, scope, new CommonProcessors.CollectProcessor<PsiMethod>(result));
        return result.toArray(new PsiMethod[result.size()]);
    }
}

