/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class VariableInIncompleteCodeSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public VariableInIncompleteCodeSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        PsiElement[] elements;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        PsiElement refElement = p.getElementToSearch();
        if (!refElement.isValid() || !(refElement instanceof PsiVariable)) {
            return;
        }
        String name = ((PsiVariable)refElement).getName();
        if (StringUtil.isEmptyOrSpaces(name)) {
            return;
        }
        SearchScope scope = p.getEffectiveSearchScope();
        if (!(scope instanceof LocalSearchScope)) {
            PsiFile file = refElement.getContainingFile();
            if (file == null || file instanceof PsiCompiledElement) {
                return;
            }
            scope = new LocalSearchScope(new PsiElement[]{file}, null, !PsiSearchHelperImpl.shouldProcessInjectedPsi(p.getScopeDeterminedByUser()));
        } else {
            elements = ((LocalSearchScope)scope).getScope();
            PsiElement[] sourceElements = ContainerUtil.findAllAsArray(elements, e -> !(e instanceof PsiCompiledElement));
            if (sourceElements.length != elements.length) {
                if (sourceElements.length == 0) {
                    return;
                }
                scope = new LocalSearchScope(sourceElements);
            }
        }
        elements = ((LocalSearchScope)scope).getScope();
        if (elements.length == 0) {
            return;
        }
        PsiSearchHelper.SERVICE.getInstance(p.getProject()).processElementsWithWord((element, offsetInElement) -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "lambda$processQuery$1"));
            }
            for (PsiElement child = element.findElementAt(offsetInElement); child != null && child.textMatches(name); child = child.getParent()) {
                PsiJavaCodeReferenceElement ref;
                if (!(child instanceof PsiJavaCodeReferenceElement) || (ref = (PsiJavaCodeReferenceElement)child).isQualified() || ref.getParent() instanceof PsiMethodCallExpression || ref.resolve() != null || ref.advancedResolve(true).getElement() != refElement) continue;
                consumer.process(ref);
            }
            return true;
        }, scope, name, (short)255, true);
    }
}

