/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFileIndexFacade
extends FileIndexFacade {
    private final DirectoryIndex myDirectoryIndex;
    private final ProjectFileIndex myFileIndex;

    public ProjectFileIndexFacade(Project project, ProjectRootManager rootManager, DirectoryIndex directoryIndex) {
        super(project);
        this.myDirectoryIndex = directoryIndex;
        this.myFileIndex = rootManager.getFileIndex();
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInContent"));
        }
        return this.myFileIndex.isInContent(file);
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInSource"));
        }
        return this.myFileIndex.isInSource(file);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInSourceContent"));
        }
        return this.myFileIndex.isInSourceContent(file);
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInLibraryClasses"));
        }
        return this.myFileIndex.isInLibraryClasses(file);
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInLibrarySource"));
        }
        return this.myFileIndex.isInLibrarySource(file);
    }

    @Override
    public boolean isExcludedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isExcludedFile"));
        }
        return this.myFileIndex.isExcluded(file);
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isUnderIgnored"));
        }
        return this.myFileIndex.isUnderIgnored(file);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "getModuleForFile"));
        }
        return this.myFileIndex.getModuleForFile(file);
    }

    @Override
    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isValidAncestor"));
        }
        if (childDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDir", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isValidAncestor"));
        }
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (!this.myDirectoryIndex.getInfoForFile(childDir).isInProject(childDir)) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    @Override
    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance(this.myProject);
        if (projectRootManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "getRootModificationTracker"));
        }
        return projectRootManager;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        Collection<UnloadedModuleDescription> collection = ModuleManager.getInstance(this.myProject).getUnloadedModuleDescriptions();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "getUnloadedModuleDescriptions"));
        }
        return collection;
    }
}

