/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ElementPatternCondition<T> {
    private final InitialPatternCondition<T> myInitialCondition;
    private final List<PatternCondition<? super T>> myConditions;

    public ElementPatternCondition(InitialPatternCondition<T> startCondition) {
        this.myInitialCondition = startCondition;
        this.myConditions = Collections.emptyList();
    }

    ElementPatternCondition(InitialPatternCondition<T> initialCondition, List<PatternCondition<? super T>> conditions) {
        this.myInitialCondition = initialCondition;
        this.myConditions = conditions;
    }

    private ElementPatternCondition(ElementPatternCondition<T> original, PatternCondition<? super T> condition) {
        this.myInitialCondition = original.getInitialCondition();
        this.myConditions = new SmartList<PatternCondition<T>>(original.getConditions());
        this.myConditions.add(condition);
    }

    @Deprecated
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        int listSize = this.myConditions.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (this.myConditions.get(i2).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(StringBuilder builder, String indent) {
        this.myInitialCondition.append(builder, indent);
        int conditionSize = this.myConditions.size();
        for (int i2 = 0; i2 < conditionSize; ++i2) {
            PatternCondition<T> condition = this.myConditions.get(i2);
            condition.append(builder.append(".\n").append(indent), indent);
        }
    }

    public List<PatternCondition<? super T>> getConditions() {
        return this.myConditions;
    }

    public InitialPatternCondition<T> getInitialCondition() {
        return this.myInitialCondition;
    }

    public ElementPatternCondition<T> append(PatternCondition<? super T> condition) {
        return new ElementPatternCondition<T>(this, condition);
    }
}

