/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePatternPackageSet
extends PatternBasedPackageSet {
    @NonNls
    public static final String SCOPE_FILE = "file";
    private Pattern myModulePattern;
    private Pattern myModuleGroupPattern;
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final String myModulePatternText;
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.search.scope.packageSet.FilePatternPackageSet");

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this.myPathPattern = filePattern;
        this.myModulePatternText = modulePattern;
        if (modulePattern == null || modulePattern.isEmpty()) {
            this.myModulePattern = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            this.myModuleGroupPattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern.substring(6, idx)), "*", ".*"));
            if (idx < modulePattern.length() - 1) {
                this.myModulePattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern.substring(idx + 1)), "*", ".*"));
            }
        } else {
            this.myModulePattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern), "*", ".*"));
        }
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull NamedScopesHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "contains"));
        }
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "contains"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return file != null && this.fileMatcher(file, fileIndex, holder != null ? holder.getProjectBaseDir() : project.getBaseDir()) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file, fileIndex);
    }

    private boolean fileMatcher(@NotNull VirtualFile virtualFile, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        String relativePath;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "fileMatcher"));
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)((Object)virtualFile)).getDelegate();
        }
        if ((relativePath = FilePatternPackageSet.getRelativePath(virtualFile, fileIndex, true, projectBaseDir)) == null) {
            LOG.error("vFile: " + virtualFile + "; projectBaseDir: " + projectBaseDir + "; content File: " + fileIndex.getContentRootForFile(virtualFile));
        }
        if (StringUtil.isEmptyOrSpaces(relativePath) && !virtualFile.equals(projectBaseDir)) {
            return false;
        }
        return this.myFilePattern.matcher(relativePath).matches();
    }

    public static boolean matchesModule(Pattern moduleGroupPattern, Pattern modulePattern, VirtualFile file, ProjectFileIndex fileIndex) {
        Module module = fileIndex.getModuleForFile(file);
        if (module != null) {
            String[] groupPath;
            if (modulePattern != null && modulePattern.matcher(module.getName()).matches()) {
                return true;
            }
            if (moduleGroupPattern != null && (groupPath = ModuleManager.getInstance(module.getProject()).getModuleGroupPath(module)) != null) {
                for (String node : groupPath) {
                    if (!moduleGroupPattern.matcher(node).matches()) continue;
                    return true;
                }
            }
        }
        return modulePattern == null && moduleGroupPattern == null;
    }

    @NotNull
    private static String escapeToRegexp(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "escapeToRegexp"));
        }
        StringBuilder builder = new StringBuilder(text2.length());
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '*') {
                builder.append(c);
                continue;
            }
            builder.append('\\').append(c);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "escapeToRegexp"));
        }
        return string;
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\" + separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\" + separator + "]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\" + separator + "(.*\\" + separator + ")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\" + separator + "]*");
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        FilePatternPackageSet filePatternPackageSet = new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
        if (filePatternPackageSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "createCopy"));
        }
        return filePatternPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        StringBuffer buf = new StringBuffer(SCOPE_FILE);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "getText"));
        }
        return string;
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual(this.myPathPattern, oldQName) || Comparing.strEqual(oldQName + "//*", this.myPathPattern) || Comparing.strEqual(oldQName + "/*", this.myPathPattern);
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile virtualFile, @NotNull ProjectFileIndex index, boolean useFQName, VirtualFile projectBaseDir) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "getRelativePath"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet", "getRelativePath"));
        }
        VirtualFile contentRootForFile = index.getContentRootForFile(virtualFile);
        if (contentRootForFile != null) {
            return VfsUtilCore.getRelativePath(virtualFile, contentRootForFile, '/');
        }
        Module module = index.getModuleForFile(virtualFile);
        if (module != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor(projectBaseDir, virtualFile, false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath(virtualFile, projectBaseDir, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile, ProjectFileIndex index) {
        StringBuilder relativePath = new StringBuilder(100);
        for (VirtualFile directory = virtualFile; directory != null && index.isInLibraryClasses(directory); directory = directory.getParent()) {
            relativePath.insert(0, '/');
            relativePath.insert(0, directory.getName());
        }
        return relativePath.toString();
    }
}

