/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BinaryLightVirtualFile
extends LightVirtualFileBase {
    private byte[] myContent;

    public BinaryLightVirtualFile() {
        this("");
    }

    public BinaryLightVirtualFile(@NonNls String name) {
        this(name, ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public BinaryLightVirtualFile(@NonNls String name, @NotNull byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "<init>"));
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, @NotNull byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "<init>"));
        }
        this(name, fileType, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(VirtualFile original, @NotNull byte[] content, long modificationStamp) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "<init>"));
        }
        this(original.getName(), original.getFileType(), content, modificationStamp);
    }

    public BinaryLightVirtualFile(String name, FileType fileType, @NotNull byte[] content, long modificationStamp) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "<init>"));
        }
        super(name, fileType, modificationStamp);
        this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
        this.setContent(content);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.myContent, this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                BinaryLightVirtualFile.this.setModificationStamp(newModificationStamp);
                byte[] content = this.toByteArray();
                BinaryLightVirtualFile.this.setContent(content);
            }
        }, this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/BinaryLightVirtualFile", "getOutputStream"));
        }
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/BinaryLightVirtualFile", "contentsToByteArray"));
        }
        return this.myContent;
    }

    public void setContent(Object requestor, @NotNull byte[] content, boolean fireEvent) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "setContent"));
        }
        this.setContent(content);
        this.setModificationStamp(LocalTimeCounter.currentTime());
    }

    private void setContent(@NotNull byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/BinaryLightVirtualFile", "setContent"));
        }
        this.myContent = content;
    }

    @NotNull
    public byte[] getContent() {
        if (this.myContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/BinaryLightVirtualFile", "getContent"));
        }
        return this.myContent;
    }

    @Override
    public String toString() {
        return "BinaryLightVirtualFile: " + this.getPresentableUrl();
    }
}

