/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementDensityInspection
extends BaseInspection {
    private static final int DEFAULT_DENSITY_LIMIT = 20;
    public int m_limit = 20;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.density.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.density.min.option", new Object[0]), this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer intDensity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.density.problem.descriptor", intDensity);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementDensityVisitor();
    }

    private static class StatementCountVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private int statementCount;

        private StatementCountVisitor() {
        }

        @Override
        public void visitStatement(@NotNull PsiStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$StatementCountVisitor", "visitStatement"));
            }
            super.visitStatement(statement);
            if (statement instanceof PsiSwitchLabelStatement || statement instanceof PsiBreakStatement) {
                return;
            }
            ++this.statementCount;
        }

        int getStatementCount() {
            return this.statementCount;
        }
    }

    private class SwitchStatementDensityVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementDensityVisitor() {
        }

        @Override
        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementDensityVisitor", "visitSwitchStatement"));
            }
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            int branchCount = SwitchUtils.calculateBranchCount(statement);
            if (branchCount == 0) {
                return;
            }
            double density = this.calculateDensity(body, branchCount);
            int intDensity = (int)(density * 100.0);
            if (intDensity > SwitchStatementDensityInspection.this.m_limit) {
                return;
            }
            this.registerStatementError(statement, intDensity);
        }

        private double calculateDensity(@NotNull PsiCodeBlock body, int branchCount) {
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/controlflow/SwitchStatementDensityInspection$SwitchStatementDensityVisitor", "calculateDensity"));
            }
            StatementCountVisitor visitor = new StatementCountVisitor();
            body.accept(visitor);
            return (double)branchCount / (double)visitor.getStatementCount();
        }
    }
}

