/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class RemoveModifierFix
extends InspectionGadgetsFix {
    private final String modifierText;

    public RemoveModifierFix(String modifierText) {
        this.modifierText = modifierText;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Remove modifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RemoveModifierFix", "getFamilyName"));
        }
        return "Remove modifier";
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("remove.modifier.quickfix", this.modifierText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/RemoveModifierFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement modifierElement = descriptor.getPsiElement();
        RemoveModifierFix.deleteElement(modifierElement);
    }
}

