/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = SystemInfo.vendorContains("Apple");
    public static final boolean isOracleJvm = SystemInfo.vendorContains("Oracle");
    public static final boolean isSunJvm = SystemInfo.vendorContains("Sun") && SystemInfo.vendorContains("Microsystems");
    public static final boolean isIbmJvm = SystemInfo.vendorContains("IBM");
    public static final boolean isJetBrainsJvm;
    public static final boolean isJetbrainsJvm;
    public static final boolean IS_AT_LEAST_JAVA9;
    public static final boolean isWin2kOrNewer;
    public static final boolean isWinXpOrNewer;
    public static final boolean isWinVistaOrNewer;
    public static final boolean isWin7OrNewer;
    public static final boolean isWin8OrNewer;
    public static final boolean isWin10OrNewer;
    private static final AtomicNullableLazyValue<File> ourWSLBashFile;
    public static final boolean isXWindow;
    public static final boolean isWayland;
    public static final boolean isGNOME;
    public static final boolean isKDE;
    public static final boolean isMacSystemMenu;
    public static final boolean isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported;
    public static final boolean is32Bit;
    public static final boolean is64Bit;
    public static final boolean isMacIntel64;
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen;
    private static final NotNullLazyValue<Boolean> ourHasXdgMime;
    public static final boolean isMacOSTiger;
    public static final boolean isMacOSLeopard;
    public static final boolean isMacOSSnowLeopard;
    public static final boolean isMacOSLion;
    public static final boolean isMacOSMountainLion;
    public static final boolean isMacOSMavericks;
    public static final boolean isMacOSYosemite;
    public static final boolean isMacOSElCapitan;
    public static final boolean isMacOSSierra;
    public static final boolean isWindowsXP;
    public static final boolean isAMD64;
    public static final boolean isOS2;

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        return Character.isDigit(rtVersion.charAt(0)) ? rtVersion : fallback;
    }

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "isOsVersionAtLeast"));
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    @Nullable
    public static File getWSLBashFile() {
        return ourWSLBashFile.getValue();
    }

    public static boolean hasWSL() {
        return SystemInfo.getWSLBashFile() != null;
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean hasXdgMime() {
        return isXWindow && ourHasXdgMime.getValue() != false;
    }

    @NotNull
    public static String getMacOSMajorVersion() {
        String string = SystemInfo.getMacOSMajorVersion(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersion"));
        }
        return string;
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    @NotNull
    public static String getMacOSVersionCode() {
        String string = SystemInfo.getMacOSVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        String string = SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        String string = SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%02d", parts[1], parts[2]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        return string;
    }

    private static int[] getMacOSVersionParts(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionParts"));
        }
        List<String> parts = StringUtil.split(version, ".");
        while (parts.size() < 3) {
            parts.add("0");
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    public static String getOsNameAndVersion() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    private static int normalize(int number) {
        return number > 9 ? 9 : number;
    }

    private static int toInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean vendorContains(String s) {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, s);
    }

    public static String getUnixReleaseName() {
        return null;
    }

    public static String getUnixReleaseVersion() {
        return null;
    }

    static {
        isJetbrainsJvm = isJetBrainsJvm = SystemInfo.vendorContains("JetBrains");
        IS_AT_LEAST_JAVA9 = SystemInfo.isJavaVersionAtLeast("9");
        isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
        isWinXpOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.1");
        isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
        isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
        isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
        isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
        ourWSLBashFile = new AtomicNullableLazyValue<File>(){

            @Override
            @Nullable
            protected File compute() {
                File bashFile;
                String windir;
                if (isWin10OrNewer && !StringUtil.isEmpty(windir = System.getenv().get("windir")) && (bashFile = new File(windir + "\\System32\\bash.exe")).exists()) {
                    return bashFile;
                }
                return null;
            }
        };
        isXWindow = isUnix && !isMac;
        isWayland = isXWindow && !StringUtil.isEmpty(System.getenv("WAYLAND_DISPLAY"));
        isGNOME = isXWindow && ObjectUtils.notNull(System.getenv("GDMSESSION"), "").startsWith("gnome");
        isKDE = isXWindow && !StringUtil.isEmpty(System.getenv("KDE_FULL_SESSION"));
        isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
        isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
        areSymLinksSupported = isUnix || isWinVistaOrNewer;
        is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
        is64Bit = !is32Bit;
        isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
        ourHasXdgOpen = new PathExecLazyValue("xdg-open");
        ourHasXdgMime = new PathExecLazyValue("xdg-mime");
        isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
        isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
        isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
        isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
        isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
        isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
        isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
        isMacOSElCapitan = isMac && SystemInfo.isOsVersionAtLeast("10.11");
        isMacOSSierra = isMac && SystemInfo.isOsVersionAtLeast("10.12");
        isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
        isAMD64 = "amd64".equals(OS_ARCH);
        isOS2 = SystemInfoRt.isOS2;
    }
}

