/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.VerifyingVisitor;

public class DefaultPicoContainer
implements AreaPicoContainer {
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new THashSet();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference(FList.emptyList());

    public DefaultPicoContainer(@Nullable PicoContainer parent) {
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance((PicoContainer)parent);
    }

    public DefaultPicoContainer() {
        this(null);
    }

    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class componentType, @NotNull List<ComponentAdapter> result) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/pico/DefaultPicoContainer", "appendNonAssignableAdaptersOfType"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/pico/DefaultPicoContainer", "appendNonAssignableAdaptersOfType"));
        }
        ArrayList<ComponentAdapter> comp = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            comp.add(componentAdapter);
        }
        for (int i = comp.size() - 1; i >= 0; --i) {
            result.add((ComponentAdapter)comp.get(i));
        }
    }

    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            return this.componentKeyToAdapterCache.get(((Class)componentKey).getName());
        }
        return null;
    }

    @Nullable
    public ComponentAdapter getComponentAdapterOfType(@NotNull Class componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/pico/DefaultPicoContainer", "getComponentAdapterOfType"));
        }
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null || componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList<ComponentAdapter> result = new SmartList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, result);
        return result;
    }

    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentAdapter", "com/intellij/util/pico/DefaultPicoContainer", "registerComponent"));
        }
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.prepend(componentAdapter))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "unregisterComponent"));
        }
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.without(adapter))) {
            }
        }
        return adapter;
    }

    public List getComponentInstances() {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List<Object> getComponentInstancesOfType(@Nullable Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result, this.getInstance(componentAdapter));
        }
        return result;
    }

    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    @Nullable
    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentAdapter", "com/intellij/util/pico/DefaultPicoContainer", "getInstance"));
        }
        if (this.getComponentAdapters().contains(componentAdapter)) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(@NotNull ComponentAdapter componentAdapter) {
        Object instance;
        Throwable firstLevelException;
        if (componentAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentAdapter", "com/intellij/util/pico/DefaultPicoContainer", "getLocalInstance"));
        }
        try {
            return componentAdapter.getComponentInstance((PicoContainer)this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
            return instance;
        }
        throw firstLevelException;
    }

    @Nullable
    public ComponentAdapter unregisterComponentByInstance(@NotNull Object componentInstance) {
        if (componentInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstance", "com/intellij/util/pico/DefaultPicoContainer", "unregisterComponentByInstance"));
        }
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            Object o = this.getInstance(adapter);
            if (o == null || !o.equals(componentInstance)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer((PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        DefaultPicoContainer defaultPicoContainer = pc;
        if (defaultPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/pico/DefaultPicoContainer", "makeChildContainer"));
        }
        return defaultPicoContainer;
    }

    public boolean addChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/util/pico/DefaultPicoContainer", "addChildContainer"));
        }
        return this.children.add(child);
    }

    public boolean removeChildContainer(@NotNull PicoContainer child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/util/pico/DefaultPicoContainer", "removeChildContainer"));
        }
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        for (ComponentAdapter adapter : this.getComponentAdapters()) {
            adapter.accept(visitor);
        }
        for (PicoContainer child : new SmartList<PicoContainer>((Collection<PicoContainer>)this.children)) {
            child.accept(visitor);
        }
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        if (componentInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentInstance", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentInstance"));
        }
        return this.registerComponent((ComponentAdapter)new InstanceComponentAdapter(componentKey, componentInstance));
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Class componentImplementation) {
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        if (componentKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        if (componentImplementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentImplementation", "com/intellij/util/pico/DefaultPicoContainer", "registerComponentImplementation"));
        }
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true);
        return this.registerComponent((ComponentAdapter)componentAdapter);
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper", "add"));
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res = this.immutableSet;
            if (res == null) {
                Object object = this.lock;
                synchronized (object) {
                    res = this.immutableSet;
                    if (res == null) {
                        this.immutableSet = res = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = res;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper", "getImmutableSet"));
            }
            return set;
        }
    }
}

