/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ReadWriteUtil {
    public static ReadWriteAccessDetector.Access getReadWriteAccess(@NotNull PsiElement[] primaryElements, @NotNull PsiElement element) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/codeInsight/highlighting/ReadWriteUtil", "getReadWriteAccess"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/ReadWriteUtil", "getReadWriteAccess"));
        }
        for (ReadWriteAccessDetector detector : Extensions.getExtensions(ReadWriteAccessDetector.EP_NAME)) {
            if (!ReadWriteUtil.isReadWriteAccessibleElements(primaryElements, detector)) continue;
            return detector.getExpressionAccess(element);
        }
        return null;
    }

    private static boolean isReadWriteAccessibleElements(@NotNull PsiElement[] primaryElements, @NotNull ReadWriteAccessDetector detector) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/codeInsight/highlighting/ReadWriteUtil", "isReadWriteAccessibleElements"));
        }
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/intellij/codeInsight/highlighting/ReadWriteUtil", "isReadWriteAccessibleElements"));
        }
        for (PsiElement element : primaryElements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }
}

