/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    @NonNls
    private static final List<IconPathPatcher> ourPatchers = new ArrayList<IconPathPatcher>(2);
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static ImageFilter IMAGE_FILTER;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static void installPathPatcher(IconPathPatcher patcher) {
        ourPatchers.add(patcher);
        IconLoader.clearCache();
    }

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        IconLoader.clearCache();
    }

    public static void setFilter(ImageFilter filter) {
        if (IMAGE_FILTER != filter) {
            IMAGE_FILTER = filter;
            IconLoader.clearCache();
        }
    }

    private static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "getReflectiveIcon"));
        }
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return icon2;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        return IconLoader.findIcon(path, aClass, computeNow, STRICT);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow, boolean strict) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        String originalPath = path;
        Pair<String, Class> patchedPath = IconLoader.patchPath(path);
        path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            aClass = (Class)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, aClass.getClassLoader());
        }
        URL myURL = aClass.getResource(path);
        if (myURL == null) {
            if (strict) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        Icon icon = IconLoader.findIcon(myURL);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = aClass.getClassLoader();
        }
        return icon;
    }

    @NotNull
    private static Pair<String, Class> patchPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "patchPath"));
        }
        for (IconPathPatcher patcher : ourPatchers) {
            String newPath = patcher.patchPath(path);
            if (newPath == null) continue;
            Pair<String, Class> pair = Pair.create(newPath, patcher.getContextClass(path));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "patchPath"));
            }
            return pair;
        }
        Pair<String, Object> pair = Pair.create(path, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "patchPath"));
        }
        return pair;
    }

    private static boolean isReflectivePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "isReflectivePath"));
        }
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        String originalPath = path;
        Pair<String, Class> patchedPath = IconLoader.patchPath(path);
        path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = ((Class)patchedPath.second).getClassLoader();
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        if (!StringUtil.startsWithChar(path, '/')) {
            return null;
        }
        URL url = classLoader.getResource(path.substring(1));
        Icon icon = IconLoader.findIcon(url);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = classLoader;
        }
        return icon;
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader", "toImage"));
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon();
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    @Nullable
    private static ImageIcon checkIcon(Image image, @NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/util/IconLoader", "checkIcon"));
        }
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        assert (icon instanceof ImageIcon);
        return (ImageIcon)icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader", "isGoodSize"));
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!IconLoader.isGoodSize(icon)) {
                LOG.error(icon);
                return EMPTY_ICON;
            }
            if (icon instanceof CachedImageIcon) {
                disabledIcon = ((CachedImageIcon)icon).asDisabledIcon();
            } else {
                float scale = UIUtil.isJreHiDPI() ? JBUI.sysScale() : 1.0f;
                BufferedImage image = new BufferedImage((int)(scale * (float)icon.getIconWidth()), (int)(scale * (float)icon.getIconHeight()), 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setColor(UIUtil.TRANSPARENT_COLOR);
                graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
                graphics.scale(scale, scale);
                icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
                graphics.dispose();
                Image img = ImageUtil.filter(image, UIUtil.getGrayFilter());
                if (UIUtil.isJreHiDPI()) {
                    img = RetinaImage.createFrom(img, scale, null);
                }
                disabledIcon = new JBImageIcon(img);
            }
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    public static Icon getTransparentIcon(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader", "getTransparentIcon"));
        }
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader", "getTransparentIcon"));
        }
        return new RetrievableIcon(){

            @Override
            @Nullable
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader", "getIconSnapshot"));
        }
        if (icon instanceof CachedImageIcon) {
            ImageIcon imageIcon = ((CachedImageIcon)icon).getRealIcon();
            if (imageIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "getIconSnapshot"));
            }
            return imageIcon;
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader", "getIconSnapshot"));
        }
        return icon2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWithTmpRegValue(String key, Boolean tempValue, Callable<T> action) {
        RegistryValue regVal = Registry.get(key);
        boolean regValOrig = regVal.asBoolean();
        regVal.setValue(tempValue);
        try {
            T t = action.call();
            return t;
        }
        catch (Exception ignore) {
            T t = null;
            return t;
        }
        finally {
            regVal.setValue(regValOrig);
        }
    }

    static {
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    extends JBUI.UpdatingJBIcon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$700();
        private int numberOfPatchers = IconLoader.access$500().size();
        private ImageFilter filter = IconLoader.access$800();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getOrComputeIcon(g);
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            return this.getOrComputeIcon(null);
        }

        protected final synchronized Icon getOrComputeIcon(@Nullable Graphics g) {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS || this.needUpdateJBUIScale((Graphics2D)g) || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size()) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.updateJBUIScale((Graphics2D)g);
                this.filter = IMAGE_FILTER;
                this.myWasComputed = true;
                this.numberOfPatchers = ourPatchers.size();
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();

        public Icon inOriginalScale() {
            Image img;
            Icon icon = this.getOrComputeIcon();
            if (icon != null && icon instanceof CachedImageIcon && (img = ((CachedImageIcon)icon).myScaledIconsCache.getOrLoadOrigImage(false)) != null) {
                icon = new ImageIcon(img);
            }
            return icon;
        }
    }

    private static final class CachedImageIcon
    extends JBUI.UpdatingJBIcon
    implements ScalableIcon {
        private volatile Object myRealIcon;
        private String myOriginalPath;
        private ClassLoader myClassLoader;
        @NotNull
        private URL myUrl;
        private volatile boolean dark;
        private volatile int numberOfPatchers;
        private boolean svg;
        private ImageFilter[] myFilters;
        private final MyScaledIconsCache myScaledIconsCache;

        private CachedImageIcon(@NotNull CachedImageIcon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "<init>"));
            }
            this.numberOfPatchers = ourPatchers.size();
            this.myScaledIconsCache = new MyScaledIconsCache();
            this.myRealIcon = null;
            this.myOriginalPath = icon.myOriginalPath;
            this.myClassLoader = icon.myClassLoader;
            this.myUrl = icon.myUrl;
            this.dark = icon.dark;
            this.numberOfPatchers = icon.numberOfPatchers;
            this.myFilters = icon.myFilters;
            this.svg = this.myOriginalPath != null ? this.myOriginalPath.toLowerCase().endsWith("svg") : false;
        }

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "<init>"));
            }
            this.numberOfPatchers = ourPatchers.size();
            this.myScaledIconsCache = new MyScaledIconsCache();
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
            this.myFilters = new ImageFilter[]{IMAGE_FILTER};
            this.svg = url.toString().endsWith("svg");
        }

        private void setGlobalFilter(ImageFilter globalFilter) {
            this.myFilters[0] = globalFilter;
        }

        private ImageFilter getGlobalFilter() {
            return this.myFilters[0];
        }

        @Override
        public boolean updateJBUIScale(Graphics2D g) {
            if (this.needUpdateJBUIScale(g)) {
                this.getRealIcon(g);
                return true;
            }
            return false;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon() {
            ImageIcon imageIcon = this.getRealIcon(null);
            if (imageIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
            }
            return imageIcon;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon(@Nullable Graphics g) {
            ImageIcon icon;
            Object realIcon;
            if (!this.isValid() || this.needUpdateJBUIScale((Graphics2D)g)) {
                if (IconLoader.isLoaderDisabled()) {
                    ImageIcon imageIcon = EMPTY_ICON;
                    if (imageIcon == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                    }
                    return imageIcon;
                }
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
                super.updateJBUIScale((Graphics2D)g);
                this.setGlobalFilter(IMAGE_FILTER);
                if (!this.isValid()) {
                    this.myScaledIconsCache.clear();
                }
                if (this.numberOfPatchers != ourPatchers.size()) {
                    URL url;
                    String path;
                    this.numberOfPatchers = ourPatchers.size();
                    Pair patchedPath = IconLoader.patchPath(this.myOriginalPath);
                    String string = path = this.myOriginalPath == null ? null : (String)patchedPath.first;
                    if (patchedPath.second != null) {
                        this.myClassLoader = ((Class)patchedPath.second).getClassLoader();
                    }
                    if (this.myClassLoader != null && path != null && path.startsWith("/") && (url = this.myClassLoader.getResource(path = path.substring(1))) != null) {
                        this.myUrl = url;
                    }
                }
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                ImageIcon imageIcon = (ImageIcon)realIcon;
                if (imageIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                }
                return imageIcon;
            }
            if (realIcon instanceof Reference && (icon = (ImageIcon)((Reference)realIcon).get()) != null) {
                ImageIcon imageIcon = icon;
                if (imageIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                }
                return imageIcon;
            }
            icon = this.myScaledIconsCache.getOrLoadIcon(this.getJBUIScale(JBUI.ScaleType.PIX));
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                this.myRealIcon = realIcon;
            }
            ImageIcon imageIcon = icon == null ? EMPTY_ICON : icon;
            if (imageIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
            }
            return imageIcon;
        }

        private boolean isValid() {
            return this.myRealIcon != null && this.dark == USE_DARK_ICONS && this.getGlobalFilter() == IMAGE_FILTER && this.numberOfPatchers == ourPatchers.size();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon(g).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(this.getJBUIScale(JBUI.ScaleType.PIX), scale);
            if (icon != null) {
                return icon;
            }
            return this;
        }

        private Icon asDisabledIcon() {
            CachedImageIcon icon = new CachedImageIcon(this);
            icon.myFilters = new ImageFilter[]{this.getGlobalFilter(), UIUtil.getGrayFilter()};
            return icon;
        }

        private class MyScaledIconsCache {
            private Map<Boolean, SoftReference<Image>> origImagesCache = Collections.synchronizedMap(new HashMap(2));
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private Map<Float, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new LinkedHashMap<Float, SoftReference<ImageIcon>>(5){

                @Override
                public boolean removeEldestEntry(Map.Entry<Float, SoftReference<ImageIcon>> entry) {
                    return this.size() > 5;
                }
            });

            private MyScaledIconsCache() {
            }

            private Image getOrLoadOrigImage(boolean needRetinaImage) {
                Image image = (Image)SoftReference.dereference(this.origImagesCache.get(needRetinaImage));
                if (image != null) {
                    return image;
                }
                image = ImageLoader.loadFromUrl(CachedImageIcon.this.myUrl, false, CachedImageIcon.this.myFilters, needRetinaImage ? 2.0f : 1.0f);
                if (image == null) {
                    return null;
                }
                this.origImagesCache.put(needRetinaImage, new SoftReference<Image>(image));
                return image;
            }

            public ImageIcon getOrScaleIcon(float pixScale, float instanceScale) {
                Image image;
                final float effectiveScale = pixScale * instanceScale;
                ImageIcon icon = (ImageIcon)SoftReference.dereference(this.scaledIconsCache.get(Float.valueOf(effectiveScale)));
                if (icon != null) {
                    return icon;
                }
                if (CachedImageIcon.this.svg) {
                    image = (Image)IconLoader.doWithTmpRegValue("ide.svg.icon", true, new Callable<Image>(){

                        @Override
                        public Image call() {
                            return ImageLoader.loadFromUrl(CachedImageIcon.this.myUrl, true, CachedImageIcon.this.myFilters, effectiveScale);
                        }
                    });
                } else {
                    boolean needRetinaImage = JBUI.isHiDPI(effectiveScale);
                    image = this.getOrLoadOrigImage(needRetinaImage);
                    if (image == null) {
                        return null;
                    }
                    if (!UIUtil.isJreHiDPIEnabled() && needRetinaImage) {
                        instanceScale = effectiveScale / 2.0f;
                    }
                    image = ImageUtil.scaleImage(image, instanceScale);
                }
                icon = IconLoader.checkIcon(image, CachedImageIcon.this.myUrl);
                if (icon != null && icon.getIconWidth() * icon.getIconHeight() * 4 < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(Float.valueOf(effectiveScale), new SoftReference<ImageIcon>(icon));
                }
                return icon;
            }

            public ImageIcon getOrLoadIcon(float pixScale) {
                return this.getOrScaleIcon(pixScale, 1.0f);
            }

            public void clear() {
                this.scaledIconsCache.clear();
                this.origImagesCache.clear();
            }
        }
    }
}

