/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionIndex
extends FileBasedIndexExtension<FunctionalExpressionKey, List<FunExprOccurrence>>
implements PsiDependentIndex {
    public static final ID<FunctionalExpressionKey, List<FunExprOccurrence>> INDEX_ID = ID.create("java.fun.expression");
    private static final KeyDescriptor<FunctionalExpressionKey> KEY_DESCRIPTOR = new KeyDescriptor<FunctionalExpressionKey>(){

        @Override
        public int getHashCode(FunctionalExpressionKey value) {
            return value.hashCode();
        }

        @Override
        public boolean isEqual(FunctionalExpressionKey val1, FunctionalExpressionKey val2) {
            return val1.equals(val2);
        }

        @Override
        public void save(@NotNull DataOutput out, FunctionalExpressionKey value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$1", "save"));
            }
            value.serializeKey(out);
        }

        @Override
        public FunctionalExpressionKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$1", "read"));
            }
            return FunctionalExpressionKey.deserializeKey(in);
        }
    };

    @NotNull
    private static List<ReferenceChainLink> createCallChain(FileLocalResolver resolver, @Nullable LighterASTNode expr) {
        ArrayList<ReferenceChainLink> chain = new ArrayList<ReferenceChainLink>();
        while (true) {
            if (expr == null) {
                List<ReferenceChainLink> list = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createCallChain"));
                }
                return list;
            }
            if (expr.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
                expr = LightTreeUtil.firstChildOfType(resolver.getLightTree(), expr, ElementType.EXPRESSION_BIT_SET);
                continue;
            }
            if (expr.getTokenType() == JavaElementType.TYPE_CAST_EXPRESSION) {
                String typeName = resolver.getShortClassTypeName(expr);
                ContainerUtil.addIfNotNull(chain, typeName != null ? new ReferenceChainLink(typeName, false, -1) : null);
                List<ReferenceChainLink> list = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createCallChain"));
                }
                return list;
            }
            boolean isCall = expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || expr.getTokenType() == JavaElementType.NEW_EXPRESSION;
            String referenceName = JavaFunctionalExpressionIndex.getReferencedMemberName(resolver.getLightTree(), expr, isCall);
            if (referenceName == null) {
                List<ReferenceChainLink> list = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createCallChain"));
                }
                return list;
            }
            LighterASTNode qualifier = JavaFunctionalExpressionIndex.getQualifier(resolver.getLightTree(), expr, isCall);
            if (qualifier == null) {
                ContainerUtil.addIfNotNull(chain, JavaFunctionalExpressionIndex.createChainStart(resolver, expr, isCall, referenceName));
                List<ReferenceChainLink> list = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createCallChain"));
                }
                return list;
            }
            chain.add(new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr)));
            expr = qualifier;
        }
    }

    @NotNull
    private static List<ReferenceChainLink> reversedChain(List<ReferenceChainLink> chain) {
        Collections.reverse(chain);
        List<ReferenceChainLink> list = chain;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "reversedChain"));
        }
        return list;
    }

    private static int getArgCount(LighterAST tree, LighterASTNode expr) {
        List<LighterASTNode> args = JavaLightTreeUtil.getArgList(tree, expr);
        return args == null ? -1 : args.size();
    }

    @Nullable
    private static LighterASTNode getQualifier(LighterAST tree, LighterASTNode expr, boolean isCall) {
        LighterASTNode qualifier = tree.getChildren(expr).get(0);
        if (isCall) {
            List<LighterASTNode> children = tree.getChildren(qualifier);
            qualifier = children.isEmpty() ? null : children.get(0);
        }
        return qualifier != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getTokenType()) ? qualifier : null;
    }

    @Nullable
    private static String getReferencedMemberName(LighterAST tree, LighterASTNode expr, boolean isCall) {
        if (isCall) {
            return JavaFunctionalExpressionIndex.getCalledMethodName(tree, expr);
        }
        if (expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, expr);
        }
        return null;
    }

    @Nullable
    private static ReferenceChainLink createChainStart(FileLocalResolver resolver, LighterASTNode expr, boolean isCall, String referenceName) {
        if (!isCall) {
            FileLocalResolver.LightResolveResult result = resolver.resolveLocally(expr);
            if (result == FileLocalResolver.LightResolveResult.UNKNOWN) {
                return null;
            }
            LighterASTNode target = result.getTarget();
            if (target != null) {
                String typeName = resolver.getShortClassTypeName(target);
                return typeName != null ? new ReferenceChainLink(typeName, false, -1) : null;
            }
        }
        return new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver.getLightTree(), expr));
    }

    @NotNull
    private static String calcExprType(LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterASTNode scope = JavaFunctionalExpressionIndex.skipExpressionsUp(resolver.getLightTree(), funExpr, TokenSet.create(JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD, JavaElementType.TYPE_CAST_EXPRESSION, JavaElementType.RETURN_STATEMENT, JavaElementType.ASSIGNMENT_EXPRESSION));
        if (scope != null) {
            if (scope.getTokenType() == JavaElementType.ASSIGNMENT_EXPRESSION) {
                LighterASTNode lValue = JavaFunctionalExpressionIndex.findExpressionChild(scope, resolver.getLightTree());
                scope = lValue == null ? null : resolver.resolveLocally(lValue).getTarget();
            } else if (scope.getTokenType() == JavaElementType.RETURN_STATEMENT) {
                scope = LightTreeUtil.getParentOfType(resolver.getLightTree(), scope, TokenSet.create(JavaElementType.METHOD), TokenSet.orSet(ElementType.MEMBER_BIT_SET, TokenSet.create(JavaElementType.LAMBDA_EXPRESSION)));
            }
        }
        String string = StringUtil.notNullize(scope == null ? null : resolver.getShortClassTypeName(scope));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "calcExprType"));
        }
        return string;
    }

    private static int getArgIndex(List<LighterASTNode> args, LighterASTNode expr) {
        for (int i2 = 0; i2 < args.size(); ++i2) {
            if (args.get(i2).getEndOffset() < expr.getEndOffset()) continue;
            return i2;
        }
        return -1;
    }

    private static FunctionalExpressionKey.CoarseType calcReturnType(final LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        LighterASTNode block = LightTreeUtil.firstChildOfType(tree, funExpr, JavaElementType.CODE_BLOCK);
        if (block == null) {
            LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(funExpr, tree);
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr) ? FunctionalExpressionKey.CoarseType.BOOLEAN : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        final Ref<Object> returnsSomething = Ref.create(null);
        final AtomicBoolean isBoolean = new AtomicBoolean();
        final AtomicBoolean hasStatements = new AtomicBoolean();
        new RecursiveLighterASTNodeWalkingVisitor(tree){

            @Override
            public void visitNode(@NotNull LighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$2", "visitNode"));
                }
                IElementType type = element.getTokenType();
                if (type == JavaElementType.LAMBDA_EXPRESSION || ElementType.MEMBER_BIT_SET.contains(type)) {
                    return;
                }
                if (type == JavaElementType.RETURN_STATEMENT) {
                    LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(element, tree);
                    returnsSomething.set(expr != null);
                    if (JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr)) {
                        isBoolean.set(true);
                    }
                    return;
                }
                if (type == JavaElementType.EXPRESSION_STATEMENT) {
                    hasStatements.set(true);
                }
                super.visitNode(element);
            }
        }.visitNode(block);
        if (isBoolean.get()) {
            return FunctionalExpressionKey.CoarseType.BOOLEAN;
        }
        if (returnsSomething.isNull()) {
            return hasStatements.get() ? FunctionalExpressionKey.CoarseType.VOID : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        return (Boolean)returnsSomething.get() != false ? FunctionalExpressionKey.CoarseType.NON_VOID : FunctionalExpressionKey.CoarseType.VOID;
    }

    @Nullable
    private static LighterASTNode findExpressionChild(@NotNull LighterASTNode element, LighterAST tree) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "findExpressionChild"));
        }
        return LightTreeUtil.firstChildOfType(tree, element, ElementType.EXPRESSION_BIT_SET);
    }

    private static boolean isBooleanExpression(LighterAST tree, @Nullable LighterASTNode expr) {
        if (expr == null) {
            return false;
        }
        IElementType type = expr.getTokenType();
        if (type == JavaElementType.LITERAL_EXPRESSION) {
            IElementType child = tree.getChildren(expr).get(0).getTokenType();
            return child == JavaTokenType.TRUE_KEYWORD || child == JavaTokenType.FALSE_KEYWORD;
        }
        if (type == JavaElementType.POLYADIC_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION) {
            return LightTreeUtil.firstChildOfType(tree, expr, PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS) != null;
        }
        if (type == JavaElementType.PREFIX_EXPRESSION) {
            return tree.getChildren(expr).get(0).getTokenType() == JavaTokenType.EXCL;
        }
        if (type == JavaElementType.PARENTH_EXPRESSION) {
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, JavaFunctionalExpressionIndex.findExpressionChild(expr, tree));
        }
        if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children = LightTreeUtil.getChildrenOfType(tree, expr, ElementType.EXPRESSION_BIT_SET);
            return children.size() == 3 && (JavaFunctionalExpressionIndex.isBooleanExpression(tree, children.get(1)) || JavaFunctionalExpressionIndex.isBooleanExpression(tree, children.get(2)));
        }
        return false;
    }

    private static int getFunExprParameterCount(LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return -1;
        }
        assert (funExpr.getTokenType() == JavaElementType.LAMBDA_EXPRESSION);
        LighterASTNode paramList = LightTreeUtil.firstChildOfType(tree, funExpr, JavaElementType.PARAMETER_LIST);
        assert (paramList != null);
        return LightTreeUtil.getChildrenOfType(tree, paramList, Constants.PARAMETER_BIT_SET).size();
    }

    @Nullable
    private static String getCalledMethodName(LighterAST tree, LighterASTNode call) {
        if (call.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            LighterASTNode anonClass = LightTreeUtil.firstChildOfType(tree, call, JavaElementType.ANONYMOUS_CLASS);
            LighterASTNode ref = LightTreeUtil.firstChildOfType(tree, anonClass != null ? anonClass : call, JavaElementType.JAVA_CODE_REFERENCE);
            return ref == null ? null : JavaLightTreeUtil.getNameIdentifierText(tree, ref);
        }
        LighterASTNode methodExpr = tree.getChildren(call).get(0);
        if (LightTreeUtil.firstChildOfType(tree, methodExpr, JavaTokenType.SUPER_KEYWORD) != null) {
            return JavaFunctionalExpressionIndex.getSuperClassName(tree, call);
        }
        if (LightTreeUtil.firstChildOfType(tree, methodExpr, JavaTokenType.THIS_KEYWORD) != null) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, JavaFunctionalExpressionIndex.findClass(tree, call));
        }
        return JavaLightTreeUtil.getNameIdentifierText(tree, methodExpr);
    }

    @Nullable
    private static String getSuperClassName(LighterAST tree, LighterASTNode call) {
        LighterASTNode aClass = JavaFunctionalExpressionIndex.findClass(tree, call);
        return JavaFunctionalExpressionIndex.getReferenceName(tree, LightTreeUtil.firstChildOfType(tree, aClass, JavaElementType.EXTENDS_LIST));
    }

    @Nullable
    private static String getReferenceName(LighterAST tree, LighterASTNode refParent) {
        return JavaLightTreeUtil.getNameIdentifierText(tree, LightTreeUtil.firstChildOfType(tree, refParent, JavaElementType.JAVA_CODE_REFERENCE));
    }

    @Nullable
    private static LighterASTNode getContainingCall(LighterAST tree, LighterASTNode node) {
        LighterASTNode expressionList = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, node, TokenSet.create(JavaElementType.EXPRESSION_LIST));
        if (expressionList != null) {
            LighterASTNode parent = tree.getParent(expressionList);
            if (parent != null && parent.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
                parent = tree.getParent(parent);
            }
            if (parent != null && (parent.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || parent.getTokenType() == JavaElementType.NEW_EXPRESSION)) {
                return parent;
            }
        }
        return null;
    }

    private static LighterASTNode skipExpressionsUp(LighterAST tree, @NotNull LighterASTNode node, TokenSet types) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "skipExpressionsUp"));
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type = node.getTokenType();
            if (types.contains(type)) {
                return node;
            }
            if (type != JavaElementType.PARENTH_EXPRESSION && type != JavaElementType.CONDITIONAL_EXPRESSION) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    private static LighterASTNode findClass(LighterAST tree, LighterASTNode node) {
        return JBIterable.generate(node, tree::getParent).find(n -> n.getTokenType() == JavaElementType.CLASS);
    }

    @Override
    @NotNull
    public KeyDescriptor<FunctionalExpressionKey> getKeyDescriptor() {
        KeyDescriptor<FunctionalExpressionKey> keyDescriptor = KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public ID<FunctionalExpressionKey, List<FunExprOccurrence>> getName() {
        ID<FunctionalExpressionKey, List<FunExprOccurrence>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "getName"));
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<FunctionalExpressionKey, List<FunExprOccurrence>, FileContent> getIndexer() {
        DataIndexer<FunctionalExpressionKey, List<FunExprOccurrence>, FileContent> dataIndexer = inputData -> {
            CharSequence text2 = inputData.getContentAsText();
            int[] offsets = ArrayUtil.mergeArrays(new StringSearcher("->", true, true).findAllOccurrences(text2), new StringSearcher("::", true, true).findAllOccurrences(text2));
            if (offsets.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<FunctionalExpressionKey, SmartList<FunExprOccurrence>> result = new HashMap<FunctionalExpressionKey, SmartList<FunExprOccurrence>>();
            LighterAST tree = ((FileContentImpl)inputData).getLighterASTForPsiDependentIndex();
            FileLocalResolver resolver = new FileLocalResolver(tree);
            for (int offset : offsets) {
                LighterASTNode element;
                LighterASTNode leaf = LightTreeUtil.findLeafElementAt(tree, offset);
                LighterASTNode lighterASTNode = element = leaf == null ? null : tree.getParent(leaf);
                if (element == null || element.getTokenType() != JavaElementType.METHOD_REF_EXPRESSION && element.getTokenType() != JavaElementType.LAMBDA_EXPRESSION) continue;
                FunctionalExpressionKey key = new FunctionalExpressionKey(JavaFunctionalExpressionIndex.getFunExprParameterCount(tree, element), JavaFunctionalExpressionIndex.calcReturnType(tree, element), JavaFunctionalExpressionIndex.calcExprType(element, resolver));
                SmartList<FunExprOccurrence> list = (SmartList<FunExprOccurrence>)result.get(key);
                if (list == null) {
                    list = new SmartList<FunExprOccurrence>();
                    result.put(key, list);
                }
                list.add(JavaFunctionalExpressionIndex.createOccurrence(element, resolver));
            }
            return result;
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    private static FunExprOccurrence createOccurrence(@NotNull LighterASTNode funExpr, FileLocalResolver resolver) {
        LighterASTNode assignment;
        LighterASTNode containingCall;
        if (funExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funExpr", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createOccurrence"));
        }
        LighterAST tree = resolver.getLightTree();
        List<LighterASTNode> args = JavaLightTreeUtil.getArgList(tree, containingCall = JavaFunctionalExpressionIndex.getContainingCall(tree, funExpr));
        int argIndex = args == null ? -1 : JavaFunctionalExpressionIndex.getArgIndex(args, funExpr);
        LighterASTNode chainExpr = containingCall;
        if (chainExpr == null && (assignment = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create(JavaElementType.ASSIGNMENT_EXPRESSION))) != null) {
            chainExpr = JavaFunctionalExpressionIndex.findExpressionChild(assignment, tree);
        }
        FunExprOccurrence funExprOccurrence = new FunExprOccurrence(funExpr.getStartOffset(), argIndex, JavaFunctionalExpressionIndex.createCallChain(resolver, chainExpr));
        if (funExprOccurrence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "createOccurrence"));
        }
        return funExprOccurrence;
    }

    @Override
    @NotNull
    public DataExternalizer<List<FunExprOccurrence>> getValueExternalizer() {
        DataExternalizer<List<FunExprOccurrence>> dataExternalizer = new DataExternalizer<List<FunExprOccurrence>>(){

            @Override
            public void save(@NotNull DataOutput out, List<FunExprOccurrence> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$3", "save"));
                }
                DataInputOutputUtil.writeINT(out, value.size());
                for (FunExprOccurrence info : value) {
                    info.serialize(out);
                }
            }

            @Override
            public List<FunExprOccurrence> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$3", "read"));
                }
                int length = DataInputOutputUtil.readINT(in);
                SmartList<FunExprOccurrence> list = new SmartList<FunExprOccurrence>();
                for (int i2 = 0; i2 < length; ++i2) {
                    list.add(FunExprOccurrence.deserialize(in));
                }
                return list;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            @Override
            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$4", "acceptInput"));
                }
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }
}

