/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnnotationElement;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        AnnotationElement annotationElement = new AnnotationElement();
        if (annotationElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createCompositeNode"));
        }
        return annotationElement;
    }

    @Override
    public PsiAnnotation createPsi(@NotNull PsiAnnotationStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createAnnotation(stub);
    }

    @Override
    public PsiAnnotation createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "createPsi"));
        }
        return new PsiAnnotationImpl(node);
    }

    @Override
    public PsiAnnotationStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String text2 = LightTreeUtil.toFilteredString(tree, node, null);
        return new PsiAnnotationStubImpl(parentStub, text2);
    }

    @Override
    public void serialize(@NotNull PsiAnnotationStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "serialize"));
        }
        dataStream.writeUTFFast(stub.getText());
    }

    @Override
    @NotNull
    public PsiAnnotationStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "deserialize"));
        }
        PsiAnnotationStubImpl psiAnnotationStubImpl = new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
        if (psiAnnotationStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "deserialize"));
        }
        return psiAnnotationStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiAnnotationStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/java/stubs/JavaAnnotationElementType", "indexStub"));
        }
        String shortName = JavaAnnotationElementType.getReferenceShortName(stub.getText());
        if (!StringUtil.isEmptyOrSpaces(shortName)) {
            sink.occurrence(JavaStubIndexKeys.ANNOTATIONS, shortName);
        }
    }

    private static String getReferenceShortName(String annotationText) {
        int index = annotationText.indexOf(40);
        if (index >= 0) {
            annotationText = annotationText.substring(0, index);
        }
        return PsiNameHelper.getShortClassName(annotationText);
    }
}

