/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotatedJavaCodeReferenceElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ConstructorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ICodeFragmentElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaCodeReferenceElementImpl
extends CompositePsiElement
implements PsiAnnotatedJavaCodeReferenceElement,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl");
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private volatile int myKindWhenDummy = 1;
    public static final int CLASS_NAME_KIND = 1;
    public static final int PACKAGE_NAME_KIND = 2;
    public static final int CLASS_OR_PACKAGE_NAME_KIND = 3;
    public static final int CLASS_FQ_NAME_KIND = 4;
    public static final int CLASS_FQ_OR_PACKAGE_NAME_KIND = 5;
    public static final int CLASS_IN_QUALIFIED_NEW_KIND = 6;
    private final int myHC = ourHC++;

    public PsiJavaCodeReferenceElementImpl() {
        super(JavaElementType.JAVA_CODE_REFERENCE);
    }

    public final int hashCode() {
        return this.myHC;
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.getReferenceNameNode();
        return refName != null ? refName.getStartOffset() : super.getTextOffset();
    }

    public void setKindWhenDummy(int kind) {
        LOG.assertTrue(PsiJavaCodeReferenceElementImpl.isDummy(this.getTreeParent().getElementType()));
        this.myKindWhenDummy = kind;
    }

    private static boolean isDummy(IElementType type) {
        return type == TokenType.DUMMY_HOLDER || type == JavaElementType.DUMMY_ELEMENT;
    }

    public int getKind(@NotNull PsiFile containingFile) {
        CompositeElement treeParent;
        IElementType i2;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getKind"));
        }
        if (!containingFile.isValid()) {
            PsiUtilCore.ensureValid(this);
        }
        if (PsiJavaCodeReferenceElementImpl.isDummy(i2 = (treeParent = this.getTreeParent()).getElementType())) {
            return this.myKindWhenDummy;
        }
        if (i2 == JavaElementType.TYPE) {
            return treeParent.getTreeParent().getPsi() instanceof PsiTypeCodeFragment ? 3 : 1;
        }
        if (i2 == JavaElementType.EXTENDS_LIST || i2 == JavaElementType.IMPLEMENTS_LIST || i2 == JavaElementType.EXTENDS_BOUND_LIST || i2 == JavaElementType.THROWS_LIST || i2 == JavaElementType.THIS_EXPRESSION || i2 == JavaElementType.SUPER_EXPRESSION || i2 == JavaDocElementType.DOC_METHOD_OR_FIELD_REF || i2 == JavaDocElementType.DOC_TAG_VALUE_ELEMENT || i2 == JavaElementType.REFERENCE_PARAMETER_LIST || i2 == JavaElementType.ANNOTATION) {
            if (this.isQualified()) {
                return 3;
            }
            return 1;
        }
        if (i2 == JavaElementType.NEW_EXPRESSION) {
            ASTNode qualifier = treeParent.findChildByRole(54);
            return qualifier != null ? 6 : 1;
        }
        if (i2 == JavaElementType.ANONYMOUS_CLASS) {
            if (treeParent.getChildRole(this) == 78) {
                LOG.assertTrue(treeParent.getTreeParent().getElementType() == JavaElementType.NEW_EXPRESSION);
                ASTNode qualifier = treeParent.getTreeParent().findChildByRole(54);
                return qualifier != null ? 6 : 1;
            }
            return 3;
        }
        if (i2 == JavaElementType.PACKAGE_STATEMENT || i2 == JavaElementType.EXPORTS_STATEMENT || i2 == JavaElementType.OPENS_STATEMENT) {
            return 2;
        }
        if (i2 == JavaElementType.IMPORT_STATEMENT) {
            boolean isOnDemand = ((PsiImportStatement)SourceTreeToPsiMap.treeToPsiNotNull(treeParent)).isOnDemand();
            return isOnDemand ? 5 : 4;
        }
        if (i2 == JavaElementType.IMPORT_STATIC_STATEMENT) {
            return 5;
        }
        if (i2 == JavaElementType.JAVA_CODE_REFERENCE) {
            int parentKind = ((PsiJavaCodeReferenceElementImpl)treeParent).getKind(containingFile);
            if (parentKind == 1) {
                return 3;
            }
            if (parentKind == 4) {
                return 5;
            }
            return parentKind;
        }
        if (i2 == JavaElementType.CLASS || i2 == JavaElementType.PARAMETER_LIST || i2 == TokenType.ERROR_ELEMENT) {
            return 3;
        }
        if (i2 == JavaElementType.IMPORT_STATIC_REFERENCE) {
            return 5;
        }
        if (i2 == JavaDocElementType.DOC_TAG || i2 == JavaDocElementType.DOC_INLINE_TAG || i2 == JavaDocElementType.DOC_REFERENCE_HOLDER || i2 == JavaDocElementType.DOC_TYPE_HOLDER) {
            PsiDocComment docComment = PsiTreeUtil.getParentOfType((PsiElement)this, PsiDocComment.class);
            if (JavaDocUtil.isInsidePackageInfo(docComment)) {
                return 5;
            }
            return 3;
        }
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(i2)) {
            PsiJavaCodeReferenceCodeFragment fragment = (PsiJavaCodeReferenceCodeFragment)treeParent.getPsi();
            return fragment.isClassesAccepted() ? 5 : 2;
        }
        if (i2 == JavaElementType.USES_STATEMENT || i2 == JavaElementType.PROVIDES_STATEMENT || i2 == JavaElementType.PROVIDES_WITH_LIST) {
            return 1;
        }
        this.diagnoseUnknownParent();
        return 1;
    }

    private void diagnoseUnknownParent() {
        CompositeElement parent;
        IElementType i2 = parent.getElementType();
        String message = "Unknown parent for java code reference: '" + parent + "'; Type: " + i2 + ";\n";
        for (parent = this.getTreeParent(); parent != null && parent.getPsi() instanceof PsiExpression; parent = parent.getTreeParent()) {
            message = message + " Parent: '" + parent + "'; \n";
        }
        if (parent != null) {
            message = message + DebugUtil.treeToString(parent, false);
        }
        LOG.error(message);
    }

    private static boolean isCodeFragmentType(IElementType type) {
        return type == TokenType.CODE_FRAGMENT || type instanceof ICodeFragmentElementType;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "deleteChildInternal"));
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            PsiModifierList modifierList = PsiImplUtil.findNeighbourModifierList(this);
            if (modifierList != null) {
                ASTNode ref = this.findChildByRole(53);
                assert (ref != null) : this;
                PsiElement lastChild = ref.getPsi().getPrevSibling();
                if (lastChild != null) {
                    modifierList.addRange(this.getFirstChild(), lastChild);
                    this.deleteChildRange(this.getFirstChild(), lastChild);
                }
            }
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                return TreeUtil.findChildBackward(this, JavaTokenType.IDENTIFIER);
            }
            case 246: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST ? lastChild : null;
            }
            case 54: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    @Override
    public final int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i2 == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i2 == JavaTokenType.DOT) {
            return 55;
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.getCanonicalText(false, null, this.getContainingFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations) {
        String string = this.getCanonicalText(annotated, annotations, this.getContainingFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    private String getCanonicalText(boolean annotated, @Nullable PsiAnnotation[] annotations, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        switch (this.getKind(containingFile)) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target;
                JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(containingFile.getProject(), containingFile, this, false, OurGenericsResolver.INSTANCE);
                PsiElement psiElement = target = results.length == 1 ? results[0].getElement() : null;
                if (target instanceof PsiClass) {
                    StringBuilder buffer = new StringBuilder();
                    PsiClass aClass = (PsiClass)target;
                    PsiElement qualifier = this.getQualifier();
                    String prefix = null;
                    if (qualifier instanceof PsiJavaCodeReferenceElementImpl) {
                        prefix = ((PsiJavaCodeReferenceElementImpl)qualifier).getCanonicalText(annotated, annotations, containingFile);
                        annotations = null;
                    } else {
                        String fqn = aClass.getQualifiedName();
                        if (fqn != null) {
                            prefix = StringUtil.getPackageName(fqn);
                        }
                    }
                    if (!StringUtil.isEmpty(prefix)) {
                        buffer.append(prefix);
                        buffer.append('.');
                    }
                    if (annotated) {
                        List<PsiAnnotation> list = annotations != null ? Arrays.asList(annotations) : this.getAnnotations();
                        PsiNameHelper.appendAnnotations(buffer, list, true);
                    }
                    buffer.append(aClass.getName());
                    PsiNameHelper.appendTypeArgs(buffer, this.getTypeParameters(), true, annotated);
                    String string = buffer.toString();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                if (target instanceof PsiPackage) {
                    String string = ((PsiPackage)target).getQualifiedName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                    }
                    return string;
                }
                LOG.assertTrue(target == null, target);
                String string = this.getNormalizedText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
            case 2: 
            case 4: 
            case 5: {
                String string = this.getNormalizedText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
                }
                return string;
            }
        }
        LOG.assertTrue(false);
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getCanonicalText"));
        }
        return null;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    public final PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @NotNull
    public static TextRange calcRangeInElement(CompositePsiElement refElement) {
        TreeElement nameChild = (TreeElement)refElement.findChildByRole(53);
        if (nameChild == null) {
            TreeElement dot = (TreeElement)refElement.findChildByRole(55);
            if (dot == null) {
                throw new IllegalStateException(refElement.toString());
            }
            TextRange textRange = TextRange.from(dot.getStartOffsetInParent() + dot.getTextLength(), 0);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "calcRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = TextRange.from(nameChild.getStartOffsetInParent(), nameChild.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "calcRangeInElement"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    private PsiSubstitutor updateSubstitutor(PsiSubstitutor subst, PsiClass psiClass) {
        PsiType[] parameters = this.getTypeParameters();
        if (psiClass != null) {
            subst = subst.putAll(psiClass, parameters);
        }
        return subst;
    }

    @NotNull
    private JavaResolveResult[] resolve(int kind, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
        }
        switch (kind) {
            case 4: {
                String text2 = this.getNormalizedText();
                if (StringUtil.isEmptyOrSpaces(text2)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClass aClass = JavaPsiFacade.getInstance(containingFile.getProject()).findClass(text2, this.getResolveScope());
                if (aClass == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!this.isQualified() && text2.equals(aClass.getQualifiedName()) && containingFile instanceof PsiJavaFile && !((PsiJavaFile)containingFile).getPackageName().isEmpty()) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aClass, this.updateSubstitutor(PsiSubstitutor.EMPTY, aClass), this, false)};
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                }
                return javaResolveResultArray;
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof JavaDummyHolder) {
                    parent = parent.getContext();
                }
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiNewExpression)) {
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        if (JavaResolveResult.EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                        }
                        return JavaResolveResult.EMPTY_ARRAY;
                    }
                    LOG.error("Invalid java reference!");
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                LOG.assertTrue(qualifier != null);
                PsiType qualifierType = qualifier.getType();
                if (qualifierType == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                if (!(qualifierType instanceof PsiClassType)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType(qualifierType);
                PsiElement resultElement = result.getElement();
                if (resultElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, containingFile);
                resultElement.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result.getSubstitutor()), this, this);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                }
                return javaResolveResultArray;
            }
            case 1: {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (!(classNameElement instanceof PsiIdentifier)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                String className = classNameElement.getText();
                ClassResolverProcessor processor = new ClassResolverProcessor(className, this, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, this, null);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                }
                return javaResolveResultArray;
            }
            case 2: {
                String packageName = this.getNormalizedText();
                Project project = this.getManager().getProject();
                PsiPackage aPackage = JavaPsiFacade.getInstance(project).findPackage(packageName);
                if (aPackage == null || !aPackage.isValid()) {
                    JavaResolveResult[] javaResolveResultArray = JavaPsiFacade.getInstance(project).isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
                    if (javaResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return javaResolveResultArray;
                }
                JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo(aPackage, PsiSubstitutor.EMPTY)};
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                }
                return javaResolveResultArray;
            }
            case 3: 
            case 5: {
                int classKind;
                int n = classKind = kind == 3 ? 1 : 4;
                if (PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatement.class) != null) {
                    JavaResolveResult[] result = this.resolve(2, containingFile);
                    JavaResolveResult[] javaResolveResultArray = result.length == 0 ? this.resolve(classKind, containingFile) : result;
                    if (javaResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                    }
                    return javaResolveResultArray;
                }
                JavaResolveResult[] result = this.resolve(classKind, containingFile);
                if (result.length == 1 && !result[0].isAccessible()) {
                    JavaResolveResult[] packageResult = this.resolve(2, containingFile);
                    if (packageResult.length != 0) {
                        result = packageResult;
                    }
                } else if (result.length == 0) {
                    result = this.resolve(2, containingFile);
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
                }
                return result;
            }
        }
        LOG.error(this);
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "resolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    @Override
    public final PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.getReferenceNameElement();
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "bindToElement"));
        }
        PsiFile containingFile = this.getContainingFile();
        CheckUtil.checkWritable(containingFile);
        if (this.isReferenceTo(element)) {
            return this;
        }
        switch (this.getKind(containingFile)) {
            case 1: 
            case 4: {
                if (!(element instanceof PsiClass)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToClass((PsiClass)element, containingFile);
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
                }
                return this.bindToPackage((PsiPackage)element);
            }
            case 3: 
            case 5: {
                if (element instanceof PsiClass) {
                    return this.bindToClass((PsiClass)element, containingFile);
                }
                if (element instanceof PsiPackage) {
                    return this.bindToPackage((PsiPackage)element);
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
            case 6: {
                if (element instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)element;
                    String name = aClass.getName();
                    if (name == null) {
                        throw new IncorrectOperationException(aClass.toString());
                    }
                    PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(containingFile.getProject()).getParserFacade();
                    PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(name, this.getParent());
                    this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
                    return ref;
                }
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(element);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    private static IncorrectOperationException cannotBindError(PsiElement element) {
        return new IncorrectOperationException("Cannot bind to " + element);
    }

    private PsiElement bindToClass(@NotNull PsiClass aClass, @NotNull PsiFile containingFile) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "bindToClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "bindToClass"));
        }
        String qName = aClass.getQualifiedName();
        Project project = containingFile.getProject();
        boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(project).useFQClassNames() && this.isFullyQualified(containingFile);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        if (qName == null) {
            qName = aClass.getName();
            assert (qName != null) : aClass;
            PsiClass psiClass = facade.getResolveHelper().resolveReferencedClass(qName, this);
            if (!this.getManager().areElementsEquivalent(psiClass, aClass)) {
                throw PsiJavaCodeReferenceElementImpl.cannotBindError(aClass);
            }
        } else if (facade.findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
            return this;
        }
        String text2 = qName;
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null) {
            text2 = text2 + parameterList.getText();
        }
        try {
            ref = facade.getParserFacade().createReferenceFromText(text2, this.getParent());
        }
        catch (IncorrectOperationException e) {
            throw new IncorrectOperationException(e.getMessage() + " [qname=" + qName + " class=" + aClass + ";" + aClass.getClass().getName() + "]");
        }
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        if (!preserveQualification) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            ref = (PsiJavaCodeReferenceElement)codeStyleManager.shortenClassReferences(ref, 8192);
        }
        return ref;
    }

    private List<PsiAnnotation> getAnnotations() {
        PsiModifierList modifierList;
        List<PsiAnnotation> annotations = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
        if (!this.isQualified() && (modifierList = PsiImplUtil.findNeighbourModifierList(this)) != null) {
            PsiImplUtil.collectTypeUseAnnotations(modifierList, annotations);
        }
        return annotations;
    }

    private boolean isFullyQualified(@NotNull PsiFile containingFile) {
        ASTNode qualifier;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "isFullyQualified"));
        }
        int kind = this.getKind(containingFile);
        switch (kind) {
            case 3: {
                if (!(this.resolve() instanceof PsiPackage)) break;
                return true;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
            default: {
                LOG.error(kind);
                return true;
            }
        }
        if ((qualifier = this.findChildByRole(54)) == null) {
            return false;
        }
        LOG.assertTrue(qualifier.getElementType() == JavaElementType.JAVA_CODE_REFERENCE);
        PsiElement refElement = ((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).resolve();
        if (refElement instanceof PsiPackage) {
            return true;
        }
        return ((PsiJavaCodeReferenceElementImpl)SourceTreeToPsiMap.treeToPsiNotNull(qualifier)).isFullyQualified(containingFile);
    }

    private PsiElement bindToPackage(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "bindToPackage"));
        }
        String qName = aPackage.getQualifiedName();
        if (qName.isEmpty()) {
            throw new IncorrectOperationException("Cannot bind to default package: " + aPackage);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(qName, this.getParent());
        this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
        return ref;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        PsiFile containingFile = this.getContainingFile();
        return this.isReferenceTo(element, containingFile);
    }

    private boolean isReferenceTo(PsiElement element, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "isReferenceTo"));
        }
        switch (this.getKind(containingFile)) {
            case 1: 
            case 6: {
                if (element instanceof PsiClass) break;
                return false;
            }
            case 4: {
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                String qName = ((PsiClass)element).getQualifiedName();
                return qName != null && qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case 2: {
                if (!(element instanceof PsiPackage)) {
                    return false;
                }
                String qName = ((PsiPackage)element).getQualifiedName();
                return qName.equals(this.getCanonicalText(false, null, containingFile));
            }
            case 3: {
                if (element instanceof PsiPackage) {
                    String qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                if (element instanceof PsiClass) {
                    PsiIdentifier nameIdentifier = ((PsiClass)element).getNameIdentifier();
                    if (nameIdentifier == null) {
                        return false;
                    }
                    PsiElement nameElement = this.getReferenceNameElement();
                    return nameElement != null && nameElement.textMatches(nameIdentifier) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
                }
                return false;
            }
            case 5: {
                String qName;
                if (element instanceof PsiClass && (qName = ((PsiClass)element).getQualifiedName()) != null && qName.equals(this.getCanonicalText(false, null, containingFile))) {
                    return !PsiUtil.isFromDefaultPackage((PsiClass)element) || PsiTreeUtil.getParentOfType((PsiElement)this, PsiImportStatementBase.class) == null;
                }
                if (element instanceof PsiPackage) {
                    qName = ((PsiPackage)element).getQualifiedName();
                    return qName.equals(this.getCanonicalText(false, null, containingFile));
                }
                return false;
            }
            default: {
                LOG.assertTrue(false);
                return true;
            }
        }
        ASTNode referenceNameElement = this.getReferenceNameNode();
        if (referenceNameElement == null || referenceNameElement.getElementType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        String name = ((PsiClass)element).getName();
        return name != null && referenceNameElement.getText().equals(name) && containingFile.getManager().areElementsEquivalent(this.resolve(), element);
    }

    private String getNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText(this);
        }
        return whiteSpaceAndComments;
    }

    @Override
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getNormalizedText(), false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "fullyQualify"));
        }
        int kind = this.getKind(this.getContainingFile());
        if (kind != 1 && kind != 3 && kind != 6) {
            LOG.error("Wrong kind " + kind);
            return;
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getQualifier() != null;
    }

    @Override
    public PsiElement getQualifier() {
        return SourceTreeToPsiMap.treeElementToPsi(this.findChildByRole(54));
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        ElementFilter filter;
        switch (this.getKind(this.getContainingFile())) {
            case 3: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            case 2: {
                filter = ElementClassFilter.PACKAGE_FILTER;
                break;
            }
            case 4: 
            case 5: {
                filter = new OrFilter();
                ((OrFilter)filter).addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                ((OrFilter)filter).addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                filter = ElementClassFilter.CLASS;
                break;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        Object[] objectArray = PsiImplUtil.getReferenceVariantsByFilter(this, filter);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getVariants"));
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "processVariants"));
        }
        OrFilter filter = new OrFilter();
        if (this.isInCode() && !(this.getParent() instanceof PsiImportStatement) && !(this.getParent() instanceof PsiReferenceList)) {
            filter.addFilter(new AndFilter((ElementFilter)ElementClassFilter.METHOD, (ElementFilter)new NotFilter(new ConstructorFilter())));
            filter.addFilter(ElementClassFilter.VARIABLE);
        }
        switch (this.getKind(this.getContainingFile())) {
            case 3: {
                filter.addFilter(ElementClassFilter.CLASS);
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 1: {
                filter.addFilter(ElementClassFilter.CLASS);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 2: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                break;
            }
            case 4: 
            case 5: {
                filter.addFilter(ElementClassFilter.PACKAGE_FILTER);
                if (!this.isQualified()) break;
                filter.addFilter(ElementClassFilter.CLASS);
                break;
            }
            case 6: {
                PsiElement parent = this.getParent();
                if (parent instanceof PsiNewExpression) {
                    PsiExpression qualifier = ((PsiNewExpression)parent).getQualifier();
                    assert (qualifier != null) : parent;
                    PsiType type = qualifier.getType();
                    PsiClass aClass = PsiUtil.resolveClassInType(type);
                    if (aClass != null) {
                        aClass.processDeclarations(new FilterScopeProcessor((ElementFilter)new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new ModifierFilter("static", false)), processor), ResolveState.initial(), null, this);
                    }
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown reference type");
            }
        }
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)filter, processor);
        PsiScopesUtil.resolveAndWalk(proc, this, null, true);
    }

    private boolean isInCode() {
        if (PsiJavaCodeReferenceElementImpl.isCodeFragmentType(this.getTreeParent().getElementType()) || this.getParent() instanceof PsiAnnotation) {
            return false;
        }
        for (PsiElement superParent = this.getParent(); superParent != null; superParent = superParent.getParent()) {
            if (superParent instanceof PsiCodeBlock || superParent instanceof PsiLocalVariable) {
                return true;
            }
            if (!(superParent instanceof PsiClass) && !(superParent instanceof PsiCatchSection)) continue;
            return false;
        }
        return false;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return SourceTreeToPsiMap.treeElementToPsi(this.getReferenceNameNode());
    }

    @Nullable
    private ASTNode getReferenceNameNode() {
        return this.findChildByRole(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
    }

    @Override
    public String getQualifiedName() {
        switch (this.getKind(this.getContainingFile())) {
            case 1: 
            case 3: 
            case 6: {
                PsiElement target = this.resolve();
                if (target instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)target;
                    String name = aClass.getQualifiedName();
                    if (name == null) {
                        name = aClass.getName();
                    }
                    return name;
                }
                if (target instanceof PsiPackage) {
                    return ((PsiPackage)target).getQualifiedName();
                }
                LOG.assertTrue(target == null);
                return this.getClassNameText();
            }
            case 2: 
            case 4: 
            case 5: {
                return this.getNormalizedText();
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public String getReferenceName() {
        ASTNode childByRole = this.getReferenceNameNode();
        if (childByRole == null) {
            return null;
        }
        return childByRole.getText();
    }

    @Override
    public final TextRange getRangeInElement() {
        return PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList == null) {
            if (PsiType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getTypeParameters"));
            }
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] psiTypeArray = parameterList.getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "getTypeParameters"));
        }
        return psiTypeArray;
    }

    @Override
    public final PsiElement getElement() {
        return this;
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public final String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            PsiJavaCodeReferenceElementImpl referenceElement = (PsiJavaCodeReferenceElementImpl)ref;
            int kind = referenceElement.getKind(containingFile);
            ResolveResult[] result = referenceElement.resolve(kind, containingFile);
            if (incompleteCode && result.length == 0 && kind != 4 && kind != 5) {
                VariableResolverProcessor processor = new VariableResolverProcessor(referenceElement, containingFile);
                PsiScopesUtil.resolveAndWalk(processor, referenceElement, null, true);
                result = processor.getResult();
                if (result.length == 0 && kind == 1) {
                    result = referenceElement.resolve(2, containingFile);
                }
            }
            JavaResolveUtil.substituteResults(referenceElement, (JavaResolveResult[])result);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaCodeReferenceElementImpl$OurGenericsResolver", "resolve"));
            }
            return result;
        }
    }
}

