/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeValueManipulator
extends AbstractElementManipulator<XmlAttributeValue> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.reference.impl.manipulators.XmlAttributeValueManipulator");

    @Override
    public XmlAttributeValue handleContentChange(@NotNull XmlAttributeValue element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String text2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "handleContentChange"));
        }
        CheckUtil.checkWritable(element);
        String oldText = element.getText();
        try {
            String textBeforeRange = oldText.substring(0, range.getStartOffset());
            String textAfterRange = oldText.substring(range.getEndOffset(), oldText.length());
            newContent = oldText.startsWith("'") || oldText.endsWith("'") ? newContent.replace("'", oldText.contains("&#39;") ? "&#39;" : "&apos;") : newContent.replace("\"", oldText.contains("&#34;") ? "&#34;" : "&quot;");
            text2 = "<a value=" + textBeforeRange + newContent + textAfterRange;
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Range: " + range + " in text: '" + oldText + "'", e);
            throw e;
        }
        Project project = element.getProject();
        XmlTag tag = element.getParent().getParent() instanceof HtmlTag ? XmlElementFactory.getInstance(project).createHTMLTagFromText(text2) : XmlElementFactory.getInstance(project).createTagFromText(text2);
        XmlAttribute attribute = tag.getAttribute("value");
        assert (attribute != null && attribute.getValueElement() != null);
        element.getNode().replaceAllChildrenToChildrenOf(attribute.getValueElement().getNode());
        return element;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
        }
        PsiElement first = xmlAttributeValue.getFirstChild();
        if (first == null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        ASTNode firstNode = first.getNode();
        assert (firstNode != null);
        PsiElement last = xmlAttributeValue.getLastChild();
        ASTNode lastNode = last != null && last != first ? last.getNode() : null;
        int textLength = xmlAttributeValue.getTextLength();
        int start = firstNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER ? first.getTextLength() : 0;
        int end = lastNode != null && lastNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? last.getTextLength() : 0;
        TextRange textRange = new TextRange(start, textLength - end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/XmlAttributeValueManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

