/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PsiArrayInitializerMemberValueImpl
extends CompositePsiElement
implements PsiArrayInitializerMemberValue {
    private static final Logger LOG = Logger.getInstance(PsiArrayInitializerMemberValueImpl.class);
    private static final TokenSet MEMBER_SET = ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET;

    public PsiArrayInitializerMemberValueImpl() {
        super(JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue[] getInitializers() {
        PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = (PsiAnnotationMemberValue[])this.getChildrenAsPsiElements(MEMBER_SET, PsiAnnotationMemberValue.ARRAY_FACTORY);
        if (psiAnnotationMemberValueArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerMemberValueImpl", "getInitializers"));
        }
        return psiAnnotationMemberValueArray;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return this.findChildByType(JavaTokenType.RBRACE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaTokenType.COMMA) {
            return 23;
        }
        if (i2 == JavaTokenType.LBRACE) {
            return 18;
        }
        if (i2 == JavaTokenType.RBRACE) {
            return 19;
        }
        if (MEMBER_SET.contains(child.getElementType())) {
            return 249;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (MEMBER_SET.contains(first.getElementType()) && MEMBER_SET.contains(last.getElementType())) {
            TreeElement firstAdded = super.addInternal(first, last, anchor, before);
            JavaSourceUtil.addSeparatingComma(this, first, MEMBER_SET);
            return firstAdded;
        }
        return super.addInternal(first, last, anchor, before);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerMemberValueImpl", "deleteChildInternal"));
        }
        if (MEMBER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiArrayInitializerMemberValueImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationArrayInitializer(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiArrayInitializerMemberValue:" + this.getText();
    }
}

