/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.SingleCharSequence;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LexerEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.ex.util.LexerEditorHighlighter");
    private static final int LEXER_INCREMENTALITY_THRESHOLD = 200;
    private static final Set<Class> ourNonIncrementalLexers = new HashSet<Class>();
    private HighlighterClient myEditor;
    private final Lexer myLexer;
    private final Map<IElementType, TextAttributes> myAttributesMap;
    private final SegmentArrayWithData mySegments;
    private final SyntaxHighlighter myHighlighter;
    private EditorColorsScheme myScheme;
    private final int myInitialState;
    protected CharSequence myText;

    public LexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "<init>"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "<init>"));
        }
        this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
        this.myScheme = scheme;
        this.myLexer = highlighter.getHighlightingLexer();
        this.myLexer.start(ArrayUtil.EMPTY_CHAR_SEQUENCE);
        this.myInitialState = this.myLexer.getState();
        this.myHighlighter = highlighter;
        this.mySegments = this.createSegments();
    }

    protected SegmentArrayWithData createSegments() {
        return new SegmentArrayWithData();
    }

    public boolean isPlain() {
        return this.myHighlighter instanceof PlainSyntaxHighlighter;
    }

    @Nullable
    protected final Document getDocument() {
        return this.myEditor != null ? this.myEditor.getDocument() : null;
    }

    public final synchronized boolean checkContentIsEqualTo(CharSequence sequence) {
        Document document = this.getDocument();
        return document != null && this.isInSyncWithDocument() && Comparing.equal(document.getImmutableCharSequence(), sequence);
    }

    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    protected Lexer getLexer() {
        return this.myLexer;
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setEditor"));
        }
        LOG.assertTrue(this.myEditor == null, "Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setColorScheme"));
        }
        this.myScheme = scheme;
        this.myAttributesMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int latestValidOffset;
        LexerEditorHighlighter lexerEditorHighlighter = this;
        // MONITORENTER : lexerEditorHighlighter
        if (!this.isInSyncWithDocument()) {
            Document document = this.getDocument();
            assert (document != null);
            if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
                ((DocumentEx)document).setInBulkUpdate(false);
            }
            this.doSetText(document.getImmutableCharSequence());
        }
        HighlighterIteratorImpl highlighterIteratorImpl = new HighlighterIteratorImpl(startOffset <= (latestValidOffset = this.mySegments.getLastValidOffset()) ? startOffset : latestValidOffset);
        // MONITOREXIT : lexerEditorHighlighter
        if (highlighterIteratorImpl != null) return highlighterIteratorImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "createIterator"));
    }

    private int packData(IElementType tokenType, int state) {
        short idx = tokenType.getIndex();
        return state == this.myInitialState ? idx : -idx;
    }

    public boolean isValid() {
        Project project = this.myEditor.getProject();
        return project != null && !project.isDisposed();
    }

    private boolean isInSyncWithDocument() {
        Document document = this.getDocument();
        return document == null || document.getTextLength() == 0 || this.mySegments.getSegmentCount() > 0;
    }

    private static boolean isInitialState(int data) {
        return data >= 0;
    }

    protected static IElementType unpackToken(int data) {
        return IElementType.find((short)Math.abs(data));
    }

    @Override
    public synchronized void documentChanged(DocumentEvent e) {
        try {
            Class<?> lexerClass;
            int oldStartIndex;
            int data;
            int startIndex;
            Document document = e.getDocument();
            CharSequence text2 = document.getImmutableCharSequence();
            if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
                this.myText = null;
                this.mySegments.removeAll();
                return;
            }
            if (this.mySegments.getSegmentCount() == 0) {
                this.setText(text2);
                return;
            }
            this.myText = text2;
            int oldStartOffset = e.getOffset();
            int segmentIndex = this.mySegments.findSegmentIndex(oldStartOffset) - 2;
            for (startIndex = oldStartIndex = Math.max(0, segmentIndex); !LexerEditorHighlighter.isInitialState(data = this.mySegments.getSegmentData(startIndex)) && startIndex != 0; --startIndex) {
            }
            int startOffset = this.mySegments.getSegmentStart(startIndex);
            int newEndOffset = e.getOffset() + e.getNewLength();
            this.myLexer.start(text2, startOffset, text2.length(), this.myInitialState);
            int lastTokenStart = -1;
            int lastLexerState = -1;
            IElementType lastTokenType = null;
            while (this.myLexer.getTokenType() != null && startIndex < oldStartIndex) {
                int tokenStart = this.myLexer.getTokenStart();
                int lexerState = this.myLexer.getState();
                if (tokenStart == lastTokenStart && lexerState == lastLexerState && this.myLexer.getTokenType() == lastTokenType) {
                    throw new IllegalStateException("Lexer is not progressing after calling advance()");
                }
                int tokenEnd = this.myLexer.getTokenEnd();
                data = this.packData(this.myLexer.getTokenType(), lexerState);
                if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data) break;
                ++startIndex;
                lastTokenType = this.myLexer.getTokenType();
                this.myLexer.advance();
                lastTokenStart = tokenStart;
                lastLexerState = lexerState;
            }
            if (ApplicationManager.getApplication().isInternal() && startOffset == 0 && startIndex > 200 && !ourNonIncrementalLexers.contains(lexerClass = this.myLexer.getClass())) {
                LOG.warn(String.format("%s is probably not incremental: no initial state throughout %d tokens", lexerClass.getName(), startIndex));
                ourNonIncrementalLexers.add(lexerClass);
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
            int repaintEnd = -1;
            int insertSegmentCount = 0;
            int oldEndIndex = -1;
            lastTokenType = null;
            SegmentArrayWithData insertSegments = new SegmentArrayWithData();
            while (this.myLexer.getTokenType() != null) {
                int shiftedTokenStart;
                int index;
                int tokenStart = this.myLexer.getTokenStart();
                int lexerState = this.myLexer.getState();
                if (tokenStart == lastTokenStart && lexerState == lastLexerState && this.myLexer.getTokenType() == lastTokenType) {
                    throw new IllegalStateException("Lexer is not progressing after calling advance()");
                }
                lastTokenStart = tokenStart;
                lastLexerState = lexerState;
                lastTokenType = this.myLexer.getTokenType();
                int tokenEnd = this.myLexer.getTokenEnd();
                data = this.packData(this.myLexer.getTokenType(), lexerState);
                if (tokenStart >= newEndOffset && lexerState == this.myInitialState && this.mySegments.getSegmentStart(index = this.mySegments.findSegmentIndex(shiftedTokenStart = tokenStart - e.getNewLength() + e.getOldLength())) == shiftedTokenStart && this.mySegments.getSegmentData(index) == data) {
                    repaintEnd = tokenStart;
                    oldEndIndex = index;
                    break;
                }
                insertSegments.setElementAt(insertSegmentCount, tokenStart, tokenEnd, data);
                ++insertSegmentCount;
                this.myLexer.advance();
            }
            int shift = e.getNewLength() - e.getOldLength();
            if (repaintEnd > 0) {
                while (insertSegmentCount > 0 && oldEndIndex > startIndex && LexerEditorHighlighter.segmentsEqual(this.mySegments, oldEndIndex - 1, insertSegments, insertSegmentCount - 1, shift) && !this.hasAdditionalData(oldEndIndex - 1)) {
                    --oldEndIndex;
                    repaintEnd = insertSegments.getSegmentStart(--insertSegmentCount);
                    insertSegments.remove(insertSegmentCount, insertSegmentCount + 1);
                }
            }
            if (repaintEnd == -1) {
                repaintEnd = text2.length();
            }
            if (oldEndIndex < 0) {
                oldEndIndex = this.mySegments.getSegmentCount();
            }
            this.mySegments.shiftSegments(oldEndIndex, shift);
            this.mySegments.replace(startIndex, oldEndIndex, insertSegments);
            if (insertSegmentCount == 0 || oldEndIndex == startIndex + 1 && insertSegmentCount == 1 && data == this.mySegments.getSegmentData(startIndex)) {
                return;
            }
            this.myEditor.repaint(startOffset, repaintEnd);
        }
        catch (ProcessCanceledException ex) {
            this.myText = null;
            this.mySegments.removeAll();
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new InvalidStateException(this, "Error updating  after " + e, ex);
        }
    }

    protected boolean hasAdditionalData(int segmentIndex) {
        return false;
    }

    @Override
    public int getPriority() {
        return 80;
    }

    private static boolean segmentsEqual(SegmentArrayWithData a1, int idx1, SegmentArrayWithData a2, int idx2, int offsetShift) {
        return a1.getSegmentStart(idx1) + offsetShift == a2.getSegmentStart(idx2) && a1.getSegmentEnd(idx1) + offsetShift == a2.getSegmentEnd(idx2) && a1.getSegmentData(idx1) == a2.getSegmentData(idx2);
    }

    public HighlighterClient getClient() {
        return this.myEditor;
    }

    protected final synchronized void resetText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "resetText"));
        }
        this.myText = null;
        this.doSetText(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setText"));
        }
        LexerEditorHighlighter lexerEditorHighlighter = this;
        synchronized (lexerEditorHighlighter) {
            this.doSetText(text2);
        }
    }

    private void doSetText(CharSequence text2) {
        IElementType tokenType;
        if (Comparing.equal(this.myText, text2)) {
            return;
        }
        this.myText = ImmutableCharSequence.asImmutable(text2);
        TokenProcessor processor = this.createTokenProcessor(0);
        int textLength = text2.length();
        this.myLexer.start(text2, 0, textLength, this.myInitialState);
        this.mySegments.removeAll();
        int i2 = 0;
        while ((tokenType = this.myLexer.getTokenType()) != null) {
            int data = this.packData(tokenType, this.myLexer.getState());
            processor.addToken(i2, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), data, tokenType);
            ++i2;
            this.myLexer.advance();
        }
        processor.finish();
        if (textLength > 0 && (this.mySegments.mySegmentCount == 0 || this.mySegments.myEnds[this.mySegments.mySegmentCount - 1] != textLength)) {
            throw new IllegalStateException("Unexpected termination offset for lexer " + this.myLexer);
        }
        if (this.myEditor != null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            UIUtil.invokeLaterIfNeeded(() -> this.myEditor.repaint(0, textLength));
        }
    }

    protected TokenProcessor createTokenProcessor(int startIndex) {
        return new TokenProcessor();
    }

    public SyntaxHighlighter getSyntaxHighlighter() {
        return this.myHighlighter;
    }

    @NotNull
    private TextAttributes getAttributes(IElementType tokenType) {
        TextAttributes attrs = this.myAttributesMap.get(tokenType);
        if (attrs == null) {
            attrs = this.convertAttributes(this.myHighlighter.getTokenHighlights(tokenType));
            this.myAttributesMap.put(tokenType, attrs);
        }
        TextAttributes textAttributes = attrs;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "getAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    public List<TextAttributes> getAttributesForPreviousAndTypedChars(@NotNull Document document, int offset, char c) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "getAttributesForPreviousAndTypedChars"));
        }
        CharSequence text2 = document.getImmutableCharSequence();
        MergingCharSequence newText = new MergingCharSequence(new MergingCharSequence(text2.subSequence(0, offset), new SingleCharSequence(c)), text2.subSequence(offset, text2.length()));
        List<IElementType> tokenTypes = this.getTokenType(newText, offset);
        List<TextAttributes> list = Arrays.asList(this.getAttributes(tokenTypes.get(0)).clone(), this.getAttributes(tokenTypes.get(1)).clone());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "getAttributesForPreviousAndTypedChars"));
        }
        return list;
    }

    @NotNull
    private List<IElementType> getTokenType(CharSequence text2, int offset) {
        int startOffset = 0;
        int data = 0;
        int oldStartIndex = 0;
        int startIndex = 0;
        if (offset > 0 && this.mySegments.getSegmentCount() > 0) {
            int segmentIndex = this.mySegments.findSegmentIndex(offset - 1) - 2;
            for (startIndex = oldStartIndex = Math.max(0, segmentIndex); !LexerEditorHighlighter.isInitialState(data = this.mySegments.getSegmentData(startIndex)) && startIndex != 0; --startIndex) {
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
        }
        this.myLexer.start(text2, startOffset, text2.length(), this.myInitialState);
        while (this.myLexer.getTokenType() != null && startIndex < oldStartIndex) {
            int tokenStart = this.myLexer.getTokenStart();
            int lexerState = this.myLexer.getState();
            int tokenEnd = this.myLexer.getTokenEnd();
            data = this.packData(this.myLexer.getTokenType(), lexerState);
            if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data) break;
            ++startIndex;
            this.myLexer.advance();
        }
        IElementType tokenType1 = null;
        IElementType tokenType2 = null;
        while (this.myLexer.getTokenType() != null) {
            int lexerState = this.myLexer.getState();
            data = this.packData(this.myLexer.getTokenType(), lexerState);
            if (tokenType1 == null && this.myLexer.getTokenEnd() >= offset) {
                tokenType1 = LexerEditorHighlighter.unpackToken(data);
            }
            if (this.myLexer.getTokenEnd() >= offset + 1) {
                tokenType2 = LexerEditorHighlighter.unpackToken(data);
                break;
            }
            this.myLexer.advance();
        }
        List<IElementType> list = Arrays.asList(tokenType1, tokenType2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "getTokenType"));
        }
        return list;
    }

    @NotNull
    TextAttributes convertAttributes(@NotNull TextAttributesKey[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "convertAttributes"));
        }
        TextAttributes attrs = new TextAttributes();
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = this.myScheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge(attrs, attrs2);
        }
        TextAttributes textAttributes = attrs;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "convertAttributes"));
        }
        return textAttributes;
    }

    public String toString() {
        return this.getClass().getName() + "(" + (this.myLexer.getClass() == FlexAdapter.class ? this.myLexer.toString() : this.myLexer.getClass().getName()) + "): '" + this.myLexer.getBufferSequence() + "'";
    }

    public SegmentArrayWithData getSegments() {
        return this.mySegments;
    }

    public static class InvalidStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private InvalidStateException(LexerEditorHighlighter highlighter, String message, Throwable cause) {
            super(highlighter.getClass().getName() + "(" + (highlighter.myLexer.getClass() == FlexAdapter.class ? highlighter.myLexer.toString() : highlighter.myLexer.getClass().getName()) + "): " + message, cause);
            this.myAttachments = new Attachment[]{new Attachment("content.txt", highlighter.myLexer.getBufferSequence().toString())};
        }

        @Override
        @NotNull
        public Attachment[] getAttachments() {
            if (this.myAttachments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter$InvalidStateException", "getAttachments"));
            }
            return this.myAttachments;
        }
    }

    public class HighlighterIteratorImpl
    implements HighlighterIterator {
        private int mySegmentIndex = 0;

        HighlighterIteratorImpl(int startOffset) {
            try {
                this.mySegmentIndex = LexerEditorHighlighter.this.mySegments.findSegmentIndex(startOffset);
            }
            catch (IllegalStateException e) {
                throw new InvalidStateException(LexerEditorHighlighter.this, "wrong state", e);
            }
        }

        public int currentIndex() {
            return this.mySegmentIndex;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return LexerEditorHighlighter.this.getAttributes(this.getTokenType());
        }

        @Override
        public int getStart() {
            return LexerEditorHighlighter.this.mySegments.getSegmentStart(this.mySegmentIndex);
        }

        @Override
        public int getEnd() {
            return LexerEditorHighlighter.this.mySegments.getSegmentEnd(this.mySegmentIndex);
        }

        @Override
        public IElementType getTokenType() {
            return LexerEditorHighlighter.unpackToken(LexerEditorHighlighter.this.mySegments.getSegmentData(this.mySegmentIndex));
        }

        @Override
        public void advance() {
            ++this.mySegmentIndex;
        }

        @Override
        public void retreat() {
            --this.mySegmentIndex;
        }

        @Override
        public boolean atEnd() {
            return this.mySegmentIndex >= LexerEditorHighlighter.this.mySegments.getSegmentCount() || this.mySegmentIndex < 0;
        }

        @Override
        public Document getDocument() {
            return LexerEditorHighlighter.this.getDocument();
        }
    }

    protected class TokenProcessor {
        protected TokenProcessor() {
        }

        public void addToken(int i2, int startOffset, int endOffset, int data, IElementType tokenType) {
            LexerEditorHighlighter.this.mySegments.setElementAt(i2, startOffset, endOffset, data);
        }

        public void finish() {
        }
    }
}

