/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processQuery"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckDeep());
        assert (parameters.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = ReadAction.compute(baseClass::getName);
            progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static void processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processInheritors"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        if (baseClass instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        SearchScope searchScope = parameters.getScope();
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search(searchScope, project, parameters.getNameCondition()).forEach(aClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$0"));
                }
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process((PsiClass)aClass);
            });
            return;
        }
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(((LocalSearchScope)searchScope).getVirtualFiles())) {
            JavaClassInheritorsSearcher.processLocalScope(project, parameters, (LocalSearchScope)searchScope, baseClass, consumer);
            return;
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project, baseClass, searchScope);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass instanceof PsiAnonymousClass && !parameters.isIncludeAnonymous() || !ReadAction.compute(() -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$processInheritors$1"));
                }
                return JavaClassInheritorsSearcher.checkCandidate(subClass, parameters) && !consumer.process(subClass);
            }).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    private static Iterable<PsiClass> getOrComputeSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        if (searchScopeForNonPhysical == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScopeForNonPhysical", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map = HighlightingCaches.getInstance((Project)project).ALL_SUB_CLASSES;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)map.get(baseClass);
        if (cached == null) {
            Function<PsiAnchor, PsiClass> converter = anchor -> ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate<PsiClass> applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = ReadAction.compute(baseClass::isPhysical);
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope(project) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor) -> DirectClassInheritorsSearch.search(candidate, scopeToUse).forEach(subClass -> {
                ProgressManager.checkCanceled();
                PsiAnchor pointer = ReadAction.compute(() -> PsiAnchor.create(subClass));
                processor.consume(pointer);
                return true;
            });
            PsiAnchor seed = ReadAction.compute(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$getOrComputeSubClasses$8"));
                }
                return PsiAnchor.create(baseClass);
            });
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map, baseClass, computed) : computed;
        }
        LazyConcurrentCollection<PsiAnchor, PsiClass> lazyConcurrentCollection = cached;
        if (lazyConcurrentCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "getOrComputeSubClasses"));
        }
        return lazyConcurrentCollection;
    }

    private static void processLocalScope(final @NotNull Project project, final @NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull LocalSearchScope searchScope, final @NotNull PsiClass baseClass, final @NotNull Processor<PsiClass> consumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "processLocalScope"));
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept(new JavaRecursiveElementVisitor(){

                            @Override
                            public void visitClass(PsiClass candidate) {
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters) && !consumer.process(candidate)) {
                                    success[0] = false;
                                    return;
                                }
                                super.visitClass(candidate);
                            }
                        });
                    }
                }
            });
        }
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "checkCandidate"));
        }
        SearchScope searchScope = parameters.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name = candidate.getName();
        return name != null && parameters.getNameCondition().value(name);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isJavaLangObject"));
        }
        return ReadAction.compute(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isJavaLangObject$9"));
            }
            return baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName());
        });
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "isFinal"));
        }
        return ReadAction.compute(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher", "lambda$isFinal$10"));
            }
            return baseClass.hasModifierProperty("final");
        });
    }
}

