/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCharsetDetector {
    @NonNls
    private static final String XML_PROLOG_START = "<?xml";
    @NonNls
    private static final byte[] XML_PROLOG_START_BYTES = CharsetToolkit.getUtf8Bytes("<?xml");
    @NonNls
    private static final String ENCODING = "encoding";
    @NonNls
    private static final byte[] ENCODING_BYTES = CharsetToolkit.getUtf8Bytes("encoding");
    @NonNls
    private static final String XML_PROLOG_END = "?>";
    @NonNls
    private static final byte[] XML_PROLOG_END_BYTES = CharsetToolkit.getUtf8Bytes("?>");

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/text/XmlCharsetDetector", "extractXmlEncodingFromProlog"));
        }
        int index = 0;
        if (CharsetToolkit.hasUTF8Bom(bytes)) {
            index = CharsetToolkit.UTF8_BOM.length;
        }
        if (!ArrayUtil.startsWith(bytes, index = XmlCharsetDetector.skipWhiteSpace(index, bytes), XML_PROLOG_START_BYTES)) {
            return null;
        }
        index += XML_PROLOG_START_BYTES.length;
        while (index < bytes.length) {
            if (ArrayUtil.startsWith(bytes, index = XmlCharsetDetector.skipWhiteSpace(index, bytes), XML_PROLOG_END_BYTES)) {
                return null;
            }
            if (ArrayUtil.startsWith(bytes, index, ENCODING_BYTES)) {
                index += ENCODING_BYTES.length;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 61) continue;
                ++index;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 39 && bytes[index] != 34) continue;
                byte quote = bytes[index];
                ++index;
                StringBuilder encoding = new StringBuilder();
                while (index < bytes.length) {
                    if (bytes[index] == quote) {
                        return encoding.toString();
                    }
                    encoding.append((char)bytes[index++]);
                }
            }
            ++index;
        }
        return null;
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull CharSequence text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/XmlCharsetDetector", "extractXmlEncodingFromProlog"));
        }
        int index = 0;
        if (!StringUtil.startsWith(text2, index = XmlCharsetDetector.skipWhiteSpace(index, text2), XML_PROLOG_START)) {
            return null;
        }
        index += XML_PROLOG_START.length();
        while (index < text2.length()) {
            if (StringUtil.startsWith(text2, index = XmlCharsetDetector.skipWhiteSpace(index, text2), XML_PROLOG_END)) {
                return null;
            }
            if (StringUtil.startsWith(text2, index, ENCODING)) {
                char quote;
                index += ENCODING.length();
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, text2)) >= text2.length() || text2.charAt(index) != '=') continue;
                ++index;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, text2)) >= text2.length() || (quote = text2.charAt(index)) != '\'' && quote != '\"') continue;
                ++index;
                StringBuilder encoding = new StringBuilder();
                while (index < text2.length()) {
                    char c = text2.charAt(index);
                    if (c == quote) {
                        return encoding.toString();
                    }
                    encoding.append(c);
                    ++index;
                }
            }
            ++index;
        }
        return null;
    }

    private static int skipWhiteSpace(int start, @NotNull byte[] bytes) {
        char c;
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/text/XmlCharsetDetector", "skipWhiteSpace"));
        }
        while (start < bytes.length && Character.isWhitespace(c = (char)bytes[start])) {
            ++start;
        }
        return start;
    }

    private static int skipWhiteSpace(int start, @NotNull CharSequence text2) {
        char c;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/XmlCharsetDetector", "skipWhiteSpace"));
        }
        while (start < text2.length() && Character.isWhitespace(c = text2.charAt(start))) {
            ++start;
        }
        return start;
    }
}

