/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    public boolean checkNotNull;
    private static final EquivalenceChecker EQUIVALENCE = new NoSideEffectExpressionEquivalenceChecker();

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.replaceable.by.objects.check.not.null.option", new Object[0]), this, "checkNotNull");
        if (singleCheckboxOptionsPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "createOptionsPanel"));
        }
        return singleCheckboxOptionsPanel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualsReplaceableByObjectsCallFix((String)infos[0], (String)infos[1], (Boolean)infos[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private static PsiExpression getArgumentExpression(PsiMethodCallExpression callExpression) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        return expressions.length == 1 ? ParenthesesUtils.stripParentheses(expressions[0]) : null;
    }

    private static PsiExpression getQualifierExpression(PsiMethodCallExpression expression) {
        return ParenthesesUtils.stripParentheses(expression.getMethodExpression().getQualifierExpression());
    }

    private static class NoSideEffectExpressionEquivalenceChecker
    extends EquivalenceChecker {
        private NoSideEffectExpressionEquivalenceChecker() {
        }

        @Override
        protected EquivalenceChecker.Match newExpressionsMatch(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
            if (newExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "newExpressionsMatch"));
            }
            if (newExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "newExpressionsMatch"));
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match methodCallExpressionsMatch(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
            if (methodCallExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "methodCallExpressionsMatch"));
            }
            if (methodCallExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "methodCallExpressionsMatch"));
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match assignmentExpressionsMatch(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
            if (assignmentExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "assignmentExpressionsMatch"));
            }
            if (assignmentExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "assignmentExpressionsMatch"));
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match arrayInitializerExpressionsMatch(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
            if (arrayInitializerExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "arrayInitializerExpressionsMatch"));
            }
            if (arrayInitializerExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "arrayInitializerExpressionsMatch"));
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match prefixExpressionsMatch(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
            if (prefixExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "prefixExpressionsMatch"));
            }
            if (prefixExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "prefixExpressionsMatch"));
            }
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(prefixExpression1.getOperationTokenType())) {
                return EXACT_MISMATCH;
            }
            return super.prefixExpressionsMatch(prefixExpression1, prefixExpression2);
        }

        @Override
        protected EquivalenceChecker.Match postfixExpressionsMatch(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
            if (postfixExpression1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression1", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "postfixExpressionsMatch"));
            }
            if (postfixExpression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression2", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker", "postfixExpressionsMatch"));
            }
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(postfixExpression1.getOperationTokenType())) {
                return EXACT_MISMATCH;
            }
            return super.postfixExpressionsMatch(postfixExpression1, postfixExpression2);
        }

        private static boolean isSideEffectUnaryOperator(IElementType tokenType) {
            return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
        }
    }

    private static class EqualsCheck {
        @NotNull
        final PsiExpression argument;
        @NotNull
        final PsiExpression qualifier;
        final boolean isEqual;

        public EqualsCheck(@NotNull PsiExpression argument, @NotNull PsiExpression qualifier, boolean isEqual) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsCheck", "<init>"));
            }
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsCheck", "<init>"));
            }
            this.argument = argument;
            this.qualifier = qualifier;
            this.isEqual = isEqual;
        }

        @Nullable
        private static EqualsCheck create(@Nullable PsiExpression maybeEqualsCheckExpression) {
            PsiMethodCallExpression callExpression;
            Negated n = Negated.create(maybeEqualsCheckExpression);
            if (n != null && n.expression instanceof PsiMethodCallExpression && "equals".equals((callExpression = (PsiMethodCallExpression)n.expression).getMethodExpression().getReferenceName())) {
                PsiExpression argument = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(callExpression);
                PsiExpression qualifier = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(callExpression);
                if (argument != null && qualifier != null) {
                    return new EqualsCheck(argument, qualifier, n.isEqual);
                }
            }
            return null;
        }
    }

    private static class NullCheck {
        @NotNull
        final PsiExpression compared;
        final boolean isEqual;

        public NullCheck(@NotNull PsiExpression compared, boolean isEqual) {
            if (compared == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compared", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NullCheck", "<init>"));
            }
            this.compared = compared;
            this.isEqual = isEqual;
        }

        @Nullable
        private static NullCheck create(@Nullable PsiExpression maybeNullCheckExpression) {
            PsiBinaryExpression binaryExpression;
            PsiExpression comparedWithNull;
            Negated n = Negated.create(maybeNullCheckExpression);
            if (n != null && n.expression instanceof PsiBinaryExpression && (comparedWithNull = ParenthesesUtils.stripParentheses(ExpressionUtils.getValueComparedWithNull(binaryExpression = (PsiBinaryExpression)n.expression))) != null) {
                boolean equal = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType());
                return new NullCheck(comparedWithNull, equal == n.isEqual);
            }
            return null;
        }
    }

    private static class Negated {
        @NotNull
        final PsiExpression expression;
        final boolean isEqual;

        public Negated(@NotNull PsiExpression expression, boolean isEqual) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$Negated", "<init>"));
            }
            this.expression = expression;
            this.isEqual = isEqual;
        }

        @Nullable
        static Negated create(@Nullable PsiExpression maybeNegatedExpression) {
            PsiPrefixExpression prefixExpression;
            boolean equal = true;
            PsiExpression expression = ParenthesesUtils.stripParentheses(maybeNegatedExpression);
            if (expression instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixExpression = (PsiPrefixExpression)expression).getOperationTokenType())) {
                equal = false;
                expression = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            }
            return expression != null ? new Negated(expression, equal) : null;
        }
    }

    private class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            String methodName = expression.getMethodExpression().getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(expression);
            if (qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return;
            }
            PsiElement parentExpression = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class, PsiPrefixExpression.class);
            if (parentExpression instanceof PsiBinaryExpression ? this.processNotNullCheck((PsiBinaryExpression)parentExpression) : parentExpression instanceof PsiConditionalExpression && this.processNotNullCondition((PsiConditionalExpression)parentExpression)) {
                return;
            }
            if (!EqualsReplaceableByObjectsCallInspection.this.checkNotNull) {
                if (qualifierExpression == null) {
                    return;
                }
                PsiExpression argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(expression);
                if (argumentExpression == null) {
                    return;
                }
                this.registerError((PsiElement)expression, qualifierExpression.getText(), argumentExpression.getText(), true);
            }
        }

        private boolean processNotNullCheck(PsiBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            PsiExpression rightOperand = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                return this.registerProblem(expression, rightOperand, true);
            }
            if (JavaTokenType.OROR.equals(tokenType) && rightOperand instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)rightOperand).getOperationTokenType())) {
                PsiExpression negatedRightOperand = ParenthesesUtils.stripParentheses(((PsiPrefixExpression)rightOperand).getOperand());
                return this.registerProblem(expression, negatedRightOperand, false);
            }
            return true;
        }

        private boolean processNotNullCondition(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "processNotNullCondition"));
            }
            NullCheck conditionNullCheck = NullCheck.create(expression.getCondition());
            if (conditionNullCheck == null) {
                return false;
            }
            PsiExpression nullBranch = conditionNullCheck.isEqual ? expression.getThenExpression() : expression.getElseExpression();
            PsiExpression nonNullBranch = conditionNullCheck.isEqual ? expression.getElseExpression() : expression.getThenExpression();
            NullCheck otherNullCheck = NullCheck.create(nullBranch);
            EqualsCheck equalsCheck = EqualsCheck.create(nonNullBranch);
            if (otherNullCheck == null || equalsCheck == null || otherNullCheck.isEqual != equalsCheck.isEqual) {
                return false;
            }
            if (EQUIVALENCE.expressionsAreEquivalent(conditionNullCheck.compared, equalsCheck.qualifier) && EQUIVALENCE.expressionsAreEquivalent(otherNullCheck.compared, equalsCheck.argument)) {
                this.registerError((PsiElement)expression, equalsCheck.qualifier.getText(), equalsCheck.argument.getText(), equalsCheck.isEqual);
                return true;
            }
            return false;
        }

        private boolean registerProblem(@NotNull PsiBinaryExpression expression, PsiExpression rightOperand, boolean equal) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "registerProblem"));
            }
            if (rightOperand instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)rightOperand;
                NullCheck nullCheck = NullCheck.create(expression.getLOperand());
                if (nullCheck != null && nullCheck.isEqual != equal) {
                    PsiExpression argumentExpression;
                    PsiExpression nullCheckedExpression = nullCheck.compared;
                    PsiExpression qualifierExpression = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(methodCallExpression);
                    if (EQUIVALENCE.expressionsAreEquivalent(qualifierExpression, nullCheckedExpression) && (argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(methodCallExpression)) != null) {
                        PsiExpression expressionToReplace = this.checkEqualityBefore(expression, equal, qualifierExpression, argumentExpression);
                        this.registerError((PsiElement)expressionToReplace, nullCheckedExpression.getText(), argumentExpression.getText(), equal);
                        return true;
                    }
                }
            }
            return false;
        }

        @NotNull
        private PsiExpression checkEqualityBefore(@NotNull PsiExpression expression, boolean equal, PsiExpression part1, PsiExpression part2) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class);
            if (parent instanceof PsiBinaryExpression) {
                PsiExpression lhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if ((equal && JavaTokenType.OROR.equals(tokenType) || !equal && JavaTokenType.ANDAND.equals(tokenType)) && PsiTreeUtil.isAncestor(binaryExpression.getROperand(), expression, false) && this.isEquality(lhs = binaryExpression.getLOperand(), equal, part1, part2)) {
                    PsiBinaryExpression psiBinaryExpression = binaryExpression;
                    if (psiBinaryExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
                    }
                    return psiBinaryExpression;
                }
            }
            PsiExpression psiExpression = expression;
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor", "checkEqualityBefore"));
            }
            return psiExpression;
        }

        private boolean isEquality(PsiExpression expression, boolean equals, PsiExpression part1, PsiExpression part2) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression leftOperand = binaryExpression.getLOperand();
            PsiExpression rightOperand = binaryExpression.getROperand();
            return EQUIVALENCE.expressionsAreEquivalent(leftOperand, part1) && EQUIVALENCE.expressionsAreEquivalent(rightOperand, part2) || EQUIVALENCE.expressionsAreEquivalent(leftOperand, part2) && EQUIVALENCE.expressionsAreEquivalent(rightOperand, part1);
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression || element instanceof PsiMethodCallExpression || element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            String expressionText = "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")";
            PsiReplacementUtil.replaceExpressionAndShorten(expression, this.myEquals != false ? expressionText : "!" + expressionText);
        }
    }
}

