/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class CastThatLosesPrecisionInspection
extends BaseInspection {
    public boolean ignoreIntegerCharCasts = false;

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("NumericCastThatLosesPrecision" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "getID"));
        }
        return "NumericCastThatLosesPrecision";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.that.loses.precision.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        boolean negativeOnly = (Boolean)infos[1];
        String string = InspectionGadgetsBundle.message(negativeOnly ? "cast.that.loses.precision.negative.problem.descriptor" : "cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), this, "ignoreIntegerCharCasts");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        @Override
        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            LongRangeSet valueRange;
            Number number;
            PsiMethod method;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor", "visitTypeCastExpression"));
            }
            PsiType castType = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType) || !TypeUtils.isNarrowingConversion(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiType.INT.equals(operandType) && PsiType.CHAR.equals(castType)) {
                return;
            }
            if (PsiType.LONG.equals(operandType) && PsiType.INT.equals(castType) && MethodUtils.isHashCode(method = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class))) {
                return;
            }
            Object result = ExpressionUtils.computeConstantExpression(operand);
            if (result instanceof Character) {
                result = (int)((Character)result).charValue();
            }
            if (result instanceof Number && this.valueIsContainableInType(number = (Number)result, castType)) {
                return;
            }
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            LongRangeSet targetRange = LongRangeSet.fromType(castType);
            LongRangeSet lostRange = LongRangeSet.all();
            if (targetRange != null && LongRangeSet.fromType(operandType) != null && (lostRange = (valueRange = this.getValueRange(operand)).subtract(targetRange)).isEmpty()) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType, lostRange.max() < 0L);
        }

        private LongRangeSet getValueRange(final @NotNull PsiExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor", "getValueRange"));
            }
            Object parent = PsiTreeUtil.getParentOfType((PsiElement)operand, PsiMethod.class, PsiLambdaExpression.class, PsiClass.class);
            parent = parent instanceof PsiMethod ? ((PsiMethod)parent).getBody() : (parent instanceof PsiLambdaExpression ? ((PsiLambdaExpression)parent).getBody() : null);
            if (parent == null) {
                return LongRangeSet.all();
            }
            StandardDataFlowRunner runner = new StandardDataFlowRunner(false, false);
            final Ref<LongRangeSet> range = Ref.create(LongRangeSet.empty());
            RunnerResult runnerResult = runner.analyzeMethod((PsiElement)parent, new StandardInstructionVisitor(){

                @Override
                public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                    if (instruction.getMethodType() == MethodCallInstruction.MethodType.CAST && instruction.getContext() == operand) {
                        LongRangeSet curRange = memState.getValueFact(DfaFactType.RANGE, memState.peek());
                        if (curRange == null) {
                            range.set(LongRangeSet.all());
                        } else {
                            range.set(((LongRangeSet)range.get()).union(curRange));
                        }
                    }
                    return super.visitMethodCall(instruction, runner, memState);
                }
            });
            return runnerResult == RunnerResult.OK ? range.get() : LongRangeSet.all();
        }

        private boolean valueIsContainableInType(Number value, PsiType type) {
            long longValue = value.longValue();
            double doubleValue = value.doubleValue();
            if (PsiType.BYTE.equals(type)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiType.CHAR.equals(type)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiType.SHORT.equals(type)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiType.INT.equals(type)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiType.LONG.equals(type)) {
                return doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiType.FLOAT.equals(type)) {
                return doubleValue == (double)value.floatValue();
            }
            return PsiType.DOUBLE.equals(type);
        }
    }
}

