/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnalysisConverter {
    private static final ThreadLocalCachedValue<MessageDigest> HASHER_CACHE = new ThreadLocalCachedValue<MessageDigest>(){

        @Override
        public MessageDigest create() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        protected void init(MessageDigest value) {
            value.reset();
        }
    };

    public static MessageDigest getMessageDigest() {
        return HASHER_CACHE.getValue();
    }

    @Nullable
    public static EKey psiKey(@NotNull PsiMethod psiMethod, @NotNull Direction direction) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "psiKey"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "psiKey"));
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        String className = BytecodeAnalysisConverter.descriptor(psiClass, 0, false);
        String methodSig = BytecodeAnalysisConverter.methodSignature(psiMethod);
        if (className == null || methodSig == null) {
            return null;
        }
        String methodName = psiMethod.getReturnType() == null ? "<init>" : psiMethod.getName();
        return new EKey((MethodDescriptor)new Method(className, methodName, methodSig), direction, true, false);
    }

    @Nullable
    private static String methodSignature(@NotNull PsiMethod psiMethod) {
        String desc;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "methodSignature"));
        }
        StringBuilder sb = new StringBuilder();
        PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)psiMethod, PsiClass.class, false);
        if (psiClass == null) {
            return null;
        }
        PsiClass outerClass = psiClass.getContainingClass();
        boolean isInnerClassConstructor = psiMethod.isConstructor() && outerClass != null && !psiClass.hasModifierProperty("static");
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        PsiType returnType = psiMethod.getReturnType();
        sb.append('(');
        if (isInnerClassConstructor) {
            desc = BytecodeAnalysisConverter.descriptor(outerClass, 0, true);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiParameter parameter : parameters) {
            desc = BytecodeAnalysisConverter.descriptor(parameter.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        if (returnType == null) {
            sb.append('V');
        } else {
            desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions, boolean full) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "descriptor"));
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            ProjectBytecodeAnalysis.LOG.debug("containingFile was not resolved for " + psiClass.getQualifiedName());
            return null;
        }
        PsiClassOwner psiFile = (PsiClassOwner)containingFile;
        String packageName = psiFile.getPackageName();
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return null;
        }
        String className = packageName.length() > 0 ? qname.substring(packageName.length() + 1).replace('.', '$') : qname.replace('.', '$');
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < dimensions; ++i2) {
            sb.append('[');
        }
        if (full) {
            sb.append('L');
        }
        if (packageName.length() > 0) {
            sb.append(packageName.replace('.', '/'));
            sb.append('/');
        }
        sb.append(className);
        if (full) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "descriptor"));
        }
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure(psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions, true);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + psiType.getCanonicalText());
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < dimensions; ++i2) {
                sb.append('[');
            }
            if (PsiType.VOID.equals(psiType)) {
                sb.append('V');
            } else if (PsiType.BOOLEAN.equals(psiType)) {
                sb.append('Z');
            } else if (PsiType.CHAR.equals(psiType)) {
                sb.append('C');
            } else if (PsiType.BYTE.equals(psiType)) {
                sb.append('B');
            } else if (PsiType.SHORT.equals(psiType)) {
                sb.append('S');
            } else if (PsiType.INT.equals(psiType)) {
                sb.append('I');
            } else if (PsiType.FLOAT.equals(psiType)) {
                sb.append('F');
            } else if (PsiType.LONG.equals(psiType)) {
                sb.append('J');
            } else if (PsiType.DOUBLE.equals(psiType)) {
                sb.append('D');
            }
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static ArrayList<EKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull EKey primaryKey) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "mkInOutKeys"));
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryKey", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "mkInOutKeys"));
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        ArrayList<EKey> keys = new ArrayList<EKey>(parameters.length * 2 + 2);
        keys.add(primaryKey);
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (!(parameters[i2].getType() instanceof PsiPrimitiveType)) {
                keys.add(primaryKey.withDirection(new Direction.InOut(i2, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InOut(i2, Value.Null)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.Null)));
                continue;
            }
            if (!PsiType.BOOLEAN.equals(parameters[i2].getType())) continue;
            keys.add(primaryKey.withDirection(new Direction.InOut(i2, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InOut(i2, Value.False)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i2, Value.False)));
        }
        ArrayList<EKey> arrayList = keys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "mkInOutKeys"));
        }
        return arrayList;
    }

    public static void addMethodAnnotations(@NotNull Map<EKey, Value> solution, @NotNull MethodAnnotations methodAnnotations, @NotNull EKey methodKey, int arity) {
        if (solution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "solution", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "addMethodAnnotations"));
        }
        if (methodAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodAnnotations", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "addMethodAnnotations"));
        }
        if (methodKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKey", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "addMethodAnnotations"));
        }
        ArrayList<StandardMethodContract> contractClauses = new ArrayList<StandardMethodContract>();
        Set<EKey> notNulls = methodAnnotations.notNulls;
        Set<EKey> pures = methodAnnotations.pures;
        Map<EKey, String> contracts2 = methodAnnotations.contractsValues;
        for (Map.Entry<EKey, Value> entry : solution.entrySet()) {
            Value value = entry.getValue();
            if (value == Value.Top || value == Value.Bot || value == Value.Fail && !pures.contains(methodKey)) continue;
            EKey key = entry.getKey().mkStable();
            Direction direction = key.getDirection();
            EKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            if (value == Value.NotNull && direction == Direction.Out) {
                notNulls.add(methodKey);
                continue;
            }
            if (value == Value.Pure && direction == Direction.Pure) {
                pures.add(methodKey);
                continue;
            }
            if (!(direction instanceof Direction.ParamValueBasedDirection)) continue;
            contractClauses.add(BytecodeAnalysisConverter.contractElement(arity, (Direction.ParamValueBasedDirection)direction, value));
        }
        if (!notNulls.contains(methodKey) && !contractClauses.isEmpty()) {
            String result;
            StandardMethodContract contract;
            Map partition = StreamEx.of(contractClauses).partitioningBy(c -> c.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION);
            List<StandardMethodContract> failingContracts = BytecodeAnalysisConverter.squashContracts((List)partition.get(true));
            List<StandardMethodContract> nonFailingContracts = BytecodeAnalysisConverter.squashContracts((List)partition.get(false));
            if (nonFailingContracts.size() == 1 && (contract = nonFailingContracts.get(0)).getReturnValue() == MethodContract.ValueConstraint.NOT_NULL_VALUE && contract.isTrivial()) {
                nonFailingContracts = Collections.emptyList();
                notNulls.add(methodKey);
            }
            if (!(result = StreamEx.of((Object[])new List[]{failingContracts, nonFailingContracts}).flatMap(list -> list.stream().map(Object::toString).map(str -> str.replace(" ", "")).sorted()).joining((CharSequence)";")).isEmpty()) {
                contracts2.put(methodKey, '\"' + result + '\"');
            }
        }
    }

    @NotNull
    private static List<StandardMethodContract> squashContracts(List<StandardMethodContract> contractClauses) {
        StandardMethodContract soleContract = ((StreamEx)StreamEx.ofPairs(contractClauses, (c1, c2) -> {
            if (c1.getReturnValue() != c2.getReturnValue()) {
                return null;
            }
            int idx = -1;
            for (int i2 = 0; i2 < c1.arguments.length; ++i2) {
                MethodContract.ValueConstraint left = c1.arguments[i2];
                MethodContract.ValueConstraint right = c2.arguments[i2];
                if (left == MethodContract.ValueConstraint.ANY_VALUE && right == MethodContract.ValueConstraint.ANY_VALUE) continue;
                if (idx >= 0 || !right.canBeNegated() || left != right.negate()) {
                    return null;
                }
                idx = i2;
            }
            return c1;
        }).nonNull()).findFirst().orElse(null);
        if (soleContract != null) {
            Arrays.fill((Object[])soleContract.arguments, (Object)MethodContract.ValueConstraint.ANY_VALUE);
            contractClauses = Collections.singletonList(soleContract);
        }
        List<StandardMethodContract> list = contractClauses;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisConverter", "squashContracts"));
        }
        return list;
    }

    public static void addEffectAnnotations(Map<EKey, Effects> puritySolutions, MethodAnnotations result, EKey methodKey, boolean constructor) {
        for (Map.Entry<EKey, Effects> entry : puritySolutions.entrySet()) {
            Set<EffectQuantum> effects = entry.getValue().effects;
            EKey key = entry.getKey().mkStable();
            EKey baseKey = key.mkBase();
            if (!methodKey.equals(baseKey) || !effects.isEmpty() && (!constructor || effects.size() != 1 || !effects.contains(EffectQuantum.ThisChangeQuantum))) continue;
            result.pures.add(methodKey);
        }
    }

    private static StandardMethodContract contractElement(int arity, Direction.ParamValueBasedDirection inOut, Value value) {
        MethodContract.ValueConstraint[] constraints = new MethodContract.ValueConstraint[arity];
        Arrays.fill((Object[])constraints, (Object)MethodContract.ValueConstraint.ANY_VALUE);
        constraints[inOut.paramIndex] = inOut.inValue.toValueConstraint();
        return new StandardMethodContract(constraints, value.toValueConstraint());
    }
}

