/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindModel
extends UserDataHolderBase
implements Cloneable {
    private final List<FindModelObserver> myObservers = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myStringToFind = "";
    private String myStringToReplace = "";
    private boolean isSearchHighlighters;
    private boolean isReplaceState;
    private boolean isWholeWordsOnly;
    private SearchContext searchContext = SearchContext.ANY;
    private boolean isFromCursor = true;
    private boolean isForward = true;
    private boolean isGlobal = true;
    private boolean isRegularExpressions;
    private boolean isCaseSensitive;
    private boolean isMultipleFiles;
    private boolean isPromptOnReplace = true;
    private boolean isReplaceAll;
    private boolean isOpenNewTab;
    private boolean isOpenInNewTabEnabled;
    private boolean isOpenNewTabVisible;
    private boolean isProjectScope = true;
    private boolean isFindAll;
    private boolean isFindAllEnabled;
    private String moduleName;
    private String directoryName;
    private boolean isWithSubdirectories = true;
    private String fileFilter;
    private String customScopeName;
    private SearchScope customScope;
    private boolean isCustomScope;
    private boolean isMultiline;
    private boolean mySearchInProjectFiles;
    private boolean isPreserveCase;
    private Pattern myPattern = PatternUtil.NOTHING;

    public static void initStringToFindNoMultiline(FindModel findModel, String s) {
        if (!StringUtil.isEmpty(s)) {
            if (!s.contains("\r") && !s.contains("\n")) {
                findModel.setStringToFind(s);
            } else {
                findModel.setStringToFind(StringUtil.escapeToRegexp(s));
                findModel.setRegularExpressions(true);
            }
        }
    }

    public void addObserver(@NotNull FindModelObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/find/FindModel", "addObserver"));
        }
        this.myObservers.add(observer);
    }

    public void removeObserver(@NotNull FindModelObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/find/FindModel", "removeObserver"));
        }
        this.myObservers.remove(observer);
    }

    private void notifyObservers() {
        for (FindModelObserver observer : this.myObservers) {
            observer.findModelChanged(this);
        }
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public void setMultiline(boolean multiline) {
        if (multiline != this.isMultiline) {
            if (!multiline) {
                FindModel.initStringToFindNoMultiline(this, this.getStringToFind());
            }
            this.isMultiline = multiline;
            this.notifyObservers();
        }
    }

    public boolean isPreserveCase() {
        return this.isPreserveCase;
    }

    public void setPreserveCase(boolean preserveCase) {
        boolean changed = this.isPreserveCase != preserveCase;
        this.isPreserveCase = preserveCase;
        if (changed) {
            this.notifyObservers();
        }
    }

    public void copyFrom(FindModel model) {
        boolean changed = !this.equals(model);
        this.myStringToFind = model.myStringToFind;
        this.myStringToReplace = model.myStringToReplace;
        this.isReplaceState = model.isReplaceState;
        this.isWholeWordsOnly = model.isWholeWordsOnly;
        this.isFromCursor = model.isFromCursor;
        this.isForward = model.isForward;
        this.isGlobal = model.isGlobal;
        this.isRegularExpressions = model.isRegularExpressions;
        this.isCaseSensitive = model.isCaseSensitive;
        this.isMultipleFiles = model.isMultipleFiles;
        this.isPromptOnReplace = model.isPromptOnReplace;
        this.isReplaceAll = model.isReplaceAll;
        this.isOpenNewTab = model.isOpenNewTab;
        this.isOpenInNewTabEnabled = model.isOpenInNewTabEnabled;
        this.isOpenNewTabVisible = model.isOpenNewTabVisible;
        this.isProjectScope = model.isProjectScope;
        this.directoryName = model.directoryName;
        this.isWithSubdirectories = model.isWithSubdirectories;
        this.isPreserveCase = model.isPreserveCase;
        this.fileFilter = model.fileFilter;
        this.moduleName = model.moduleName;
        this.customScopeName = model.customScopeName;
        this.customScope = model.customScope;
        this.isCustomScope = model.isCustomScope;
        this.isFindAll = model.isFindAll;
        this.searchContext = model.searchContext;
        this.isMultiline = model.isMultiline;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindModel findModel = (FindModel)o;
        if (this.isCaseSensitive != findModel.isCaseSensitive) {
            return false;
        }
        if (this.isCustomScope != findModel.isCustomScope) {
            return false;
        }
        if (this.isFindAll != findModel.isFindAll) {
            return false;
        }
        if (this.isFindAllEnabled != findModel.isFindAllEnabled) {
            return false;
        }
        if (this.isForward != findModel.isForward) {
            return false;
        }
        if (this.isFromCursor != findModel.isFromCursor) {
            return false;
        }
        if (this.isGlobal != findModel.isGlobal) {
            return false;
        }
        if (this.searchContext != findModel.searchContext) {
            return false;
        }
        if (this.isMultiline != findModel.isMultiline) {
            return false;
        }
        if (this.isMultipleFiles != findModel.isMultipleFiles) {
            return false;
        }
        if (this.isOpenInNewTabEnabled != findModel.isOpenInNewTabEnabled) {
            return false;
        }
        if (this.isOpenNewTab != findModel.isOpenNewTab) {
            return false;
        }
        if (this.isOpenNewTabVisible != findModel.isOpenNewTabVisible) {
            return false;
        }
        if (this.isPreserveCase != findModel.isPreserveCase) {
            return false;
        }
        if (this.isProjectScope != findModel.isProjectScope) {
            return false;
        }
        if (this.isPromptOnReplace != findModel.isPromptOnReplace) {
            return false;
        }
        if (this.isRegularExpressions != findModel.isRegularExpressions) {
            return false;
        }
        if (this.isReplaceAll != findModel.isReplaceAll) {
            return false;
        }
        if (this.isReplaceState != findModel.isReplaceState) {
            return false;
        }
        if (this.isSearchHighlighters != findModel.isSearchHighlighters) {
            return false;
        }
        if (this.isWholeWordsOnly != findModel.isWholeWordsOnly) {
            return false;
        }
        if (this.isWithSubdirectories != findModel.isWithSubdirectories) {
            return false;
        }
        if (this.customScope != null ? !this.customScope.equals(findModel.customScope) : findModel.customScope != null) {
            return false;
        }
        if (this.customScopeName != null ? !this.customScopeName.equals(findModel.customScopeName) : findModel.customScopeName != null) {
            return false;
        }
        if (this.directoryName != null ? !this.directoryName.equals(findModel.directoryName) : findModel.directoryName != null) {
            return false;
        }
        if (this.fileFilter != null ? !this.fileFilter.equals(findModel.fileFilter) : findModel.fileFilter != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(findModel.moduleName) : findModel.moduleName != null) {
            return false;
        }
        if (this.myStringToFind != null ? !this.myStringToFind.equals(findModel.myStringToFind) : findModel.myStringToFind != null) {
            return false;
        }
        if (this.myStringToReplace != null ? !this.myStringToReplace.equals(findModel.myStringToReplace) : findModel.myStringToReplace != null) {
            return false;
        }
        return this.mySearchInProjectFiles == findModel.mySearchInProjectFiles;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myStringToFind != null ? this.myStringToFind.hashCode() : 0);
        result = 31 * result + (this.myStringToReplace != null ? this.myStringToReplace.hashCode() : 0);
        result = 31 * result + (this.isSearchHighlighters ? 1 : 0);
        result = 31 * result + (this.isReplaceState ? 1 : 0);
        result = 31 * result + (this.isWholeWordsOnly ? 1 : 0);
        result = 31 * result + this.searchContext.ordinal();
        result = 31 * result + (this.isFromCursor ? 1 : 0);
        result = 31 * result + (this.isForward ? 1 : 0);
        result = 31 * result + (this.isGlobal ? 1 : 0);
        result = 31 * result + (this.isRegularExpressions ? 1 : 0);
        result = 31 * result + (this.isCaseSensitive ? 1 : 0);
        result = 31 * result + (this.isMultipleFiles ? 1 : 0);
        result = 31 * result + (this.isPromptOnReplace ? 1 : 0);
        result = 31 * result + (this.isReplaceAll ? 1 : 0);
        result = 31 * result + (this.isOpenNewTab ? 1 : 0);
        result = 31 * result + (this.isOpenInNewTabEnabled ? 1 : 0);
        result = 31 * result + (this.isOpenNewTabVisible ? 1 : 0);
        result = 31 * result + (this.isProjectScope ? 1 : 0);
        result = 31 * result + (this.isFindAll ? 1 : 0);
        result = 31 * result + (this.isFindAllEnabled ? 1 : 0);
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.directoryName != null ? this.directoryName.hashCode() : 0);
        result = 31 * result + (this.isWithSubdirectories ? 1 : 0);
        result = 31 * result + (this.fileFilter != null ? this.fileFilter.hashCode() : 0);
        result = 31 * result + (this.customScopeName != null ? this.customScopeName.hashCode() : 0);
        result = 31 * result + (this.customScope != null ? this.customScope.hashCode() : 0);
        result = 31 * result + (this.isCustomScope ? 1 : 0);
        result = 31 * result + (this.isMultiline ? 1 : 0);
        result = 31 * result + (this.isPreserveCase ? 1 : 0);
        result = 31 * result + (this.mySearchInProjectFiles ? 1 : 0);
        result = 31 * result + (this.myPattern != null ? this.myPattern.hashCode() : 0);
        return result;
    }

    @NotNull
    public String getStringToFind() {
        String string = this.myStringToFind;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/FindModel", "getStringToFind"));
        }
        return string;
    }

    public void setStringToFind(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/FindModel", "setStringToFind"));
        }
        boolean changed = !StringUtil.equals(s, this.myStringToFind);
        this.myStringToFind = s;
        this.myPattern = PatternUtil.NOTHING;
        if (changed) {
            this.notifyObservers();
        }
    }

    @NotNull
    public String getStringToReplace() {
        String string = this.myStringToReplace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/FindModel", "getStringToReplace"));
        }
        return string;
    }

    public void setStringToReplace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/FindModel", "setStringToReplace"));
        }
        boolean changed = !StringUtil.equals(s, this.myStringToReplace);
        this.myStringToReplace = s;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceState() {
        return this.isReplaceState;
    }

    public void setReplaceState(boolean val) {
        boolean changed = val != this.isReplaceState;
        this.isReplaceState = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFromCursor() {
        return this.isFromCursor;
    }

    public void setFromCursor(boolean val) {
        boolean changed = val != this.isFromCursor;
        this.isFromCursor = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean val) {
        boolean changed = val != this.isForward;
        this.isForward = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isRegularExpressions() {
        return this.isRegularExpressions;
    }

    public void setRegularExpressions(boolean val) {
        boolean changed = val != this.isRegularExpressions;
        this.isRegularExpressions = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean val) {
        boolean changed = val != this.isCaseSensitive;
        this.isCaseSensitive = val;
        if (changed) {
            this.myPattern = PatternUtil.NOTHING;
            this.notifyObservers();
        }
    }

    public boolean isMultipleFiles() {
        return this.isMultipleFiles;
    }

    public void setMultipleFiles(boolean val) {
        boolean changed = val != this.isMultipleFiles;
        this.isMultipleFiles = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isPromptOnReplace() {
        return this.isPromptOnReplace;
    }

    public void setPromptOnReplace(boolean val) {
        boolean changed = val != this.isPromptOnReplace;
        this.isPromptOnReplace = val;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isWholeWordsOnly() {
        return this.isWholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean isWholeWordsOnly) {
        boolean changed = isWholeWordsOnly != this.isWholeWordsOnly;
        this.isWholeWordsOnly = isWholeWordsOnly;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        boolean changed = this.isGlobal != isGlobal;
        this.isGlobal = isGlobal;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceAll() {
        return this.isReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.isReplaceAll = replaceAll;
        this.notifyObservers();
    }

    public boolean isOpenInNewTab() {
        return this.isOpenNewTab;
    }

    public void setOpenInNewTab(boolean showInNewTab) {
        boolean changed = showInNewTab != this.isOpenNewTab;
        this.isOpenNewTab = showInNewTab;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isOpenInNewTabEnabled() {
        return this.isOpenInNewTabEnabled;
    }

    public void setOpenInNewTabEnabled(boolean showInNewTabEnabled) {
        boolean changed = this.isOpenInNewTabEnabled != showInNewTabEnabled;
        this.isOpenInNewTabEnabled = showInNewTabEnabled;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isOpenInNewTabVisible() {
        return this.isOpenNewTabVisible;
    }

    public void setOpenInNewTabVisible(boolean showInNewTabVisible) {
        boolean changed = showInNewTabVisible != this.isOpenNewTabVisible;
        this.isOpenNewTabVisible = showInNewTabVisible;
        if (changed) {
            this.notifyObservers();
        }
    }

    @Nullable
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(@Nullable String directoryName) {
        String path;
        boolean changed = !StringUtil.equals(directoryName, directoryName);
        this.directoryName = directoryName;
        if (changed) {
            this.notifyObservers();
        }
        if (directoryName != null && ((path = FileUtil.toSystemIndependentName(directoryName)).endsWith("/.idea") || path.contains("/.idea/"))) {
            this.setSearchInProjectFiles(true);
        }
    }

    public boolean isWithSubdirectories() {
        return this.isWithSubdirectories;
    }

    public void setWithSubdirectories(boolean withSubdirectories) {
        boolean changed = withSubdirectories != this.isWithSubdirectories;
        this.isWithSubdirectories = withSubdirectories;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isProjectScope() {
        return this.isProjectScope;
    }

    public void setProjectScope(boolean projectScope) {
        boolean changed = projectScope != this.isProjectScope;
        this.isProjectScope = projectScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    @Override
    public FindModel clone() {
        return (FindModel)super.clone();
    }

    public String toString() {
        return "--- FIND MODEL ---\nmyStringToFind =" + this.myStringToFind + "\nmyStringToReplace =" + this.myStringToReplace + "\nisReplaceState =" + this.isReplaceState + "\nisWholeWordsOnly =" + this.isWholeWordsOnly + "\nsearchContext =" + (Object)((Object)this.searchContext) + "\nisFromCursor =" + this.isFromCursor + "\nisForward =" + this.isForward + "\nisGlobal =" + this.isGlobal + "\nisRegularExpressions =" + this.isRegularExpressions + "\nisCaseSensitive =" + this.isCaseSensitive + "\nisMultipleFiles =" + this.isMultipleFiles + "\nisPromptOnReplace =" + this.isPromptOnReplace + "\nisReplaceAll =" + this.isReplaceAll + "\nisOpenNewTab =" + this.isOpenNewTab + "\nisOpenInNewTabEnabled =" + this.isOpenInNewTabEnabled + "\nisOpenNewTabVisible =" + this.isOpenNewTabVisible + "\nisProjectScope =" + this.isProjectScope + "\ndirectoryName =" + this.directoryName + "\nisWithSubdirectories =" + this.isWithSubdirectories + "\nfileFilter =" + this.fileFilter + "\nmoduleName =" + this.moduleName + "\ncustomScopeName =" + this.customScopeName + "\nsearchInProjectFiles =" + this.mySearchInProjectFiles + "\n";
    }

    public boolean searchHighlighters() {
        return this.isSearchHighlighters;
    }

    public void setSearchHighlighters(boolean search) {
        boolean changed = search != this.isSearchHighlighters;
        this.isSearchHighlighters = search;
        if (changed) {
            this.notifyObservers();
        }
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(String fileFilter) {
        boolean changed = !StringUtil.equals(fileFilter, this.fileFilter);
        this.fileFilter = fileFilter;
        if (changed) {
            this.notifyObservers();
        }
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        boolean changed = !StringUtil.equals(moduleName, this.moduleName);
        this.moduleName = moduleName;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFindAll() {
        return this.isFindAll;
    }

    public void setFindAll(boolean findAll) {
        boolean changed = this.isFindAll != findAll;
        this.isFindAll = findAll;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isFindAllEnabled() {
        return this.isFindAllEnabled;
    }

    public void setFindAllEnabled(boolean findAllEnabled) {
        boolean changed = this.isFindAllEnabled != findAllEnabled;
        this.isFindAllEnabled = findAllEnabled;
        if (changed) {
            this.notifyObservers();
        }
    }

    public String getCustomScopeName() {
        return this.customScopeName;
    }

    public void setCustomScopeName(String customScopeName) {
        boolean changed = !StringUtil.equals(customScopeName, this.customScopeName);
        this.customScopeName = customScopeName;
        if (changed) {
            this.notifyObservers();
        }
    }

    public SearchScope getCustomScope() {
        return this.customScope;
    }

    public void setCustomScope(SearchScope customScope) {
        boolean changed = this.customScope != null ? this.customScope.equals(customScope) : customScope != null;
        this.customScope = customScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isCustomScope() {
        return this.isCustomScope;
    }

    public void setCustomScope(boolean customScope) {
        boolean changed = this.isCustomScope != customScope;
        this.isCustomScope = customScope;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isInStringLiteralsOnly() {
        return this.searchContext == SearchContext.IN_STRING_LITERALS;
    }

    public boolean isExceptComments() {
        return this.searchContext == SearchContext.EXCEPT_COMMENTS;
    }

    public boolean isExceptStringLiterals() {
        return this.searchContext == SearchContext.EXCEPT_STRING_LITERALS;
    }

    public boolean isInCommentsOnly() {
        return this.searchContext == SearchContext.IN_COMMENTS;
    }

    public boolean isExceptCommentsAndStringLiterals() {
        return this.searchContext == SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
    }

    @Deprecated
    public void setInCommentsOnly(boolean inCommentsOnly) {
        this.doApplyContextChange(inCommentsOnly, SearchContext.IN_COMMENTS);
    }

    @Deprecated
    public void setInStringLiteralsOnly(boolean inStringLiteralsOnly) {
        this.doApplyContextChange(inStringLiteralsOnly, SearchContext.IN_STRING_LITERALS);
    }

    private void doApplyContextChange(boolean newOptionValue, SearchContext option) {
        boolean changed = false;
        if (newOptionValue) {
            changed = this.searchContext != option;
            this.searchContext = option;
        } else if (this.searchContext == option) {
            changed = true;
            this.searchContext = SearchContext.ANY;
        }
        if (changed) {
            this.notifyObservers();
        }
    }

    @NotNull
    public SearchContext getSearchContext() {
        SearchContext searchContext = this.searchContext;
        if (searchContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/FindModel", "getSearchContext"));
        }
        return searchContext;
    }

    public void setSearchContext(@NotNull SearchContext _searchContext) {
        if (_searchContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_searchContext", "com/intellij/find/FindModel", "setSearchContext"));
        }
        this.doSetContext(_searchContext);
    }

    private void doSetContext(SearchContext newSearchContext) {
        boolean changed = newSearchContext != this.searchContext;
        this.searchContext = newSearchContext;
        if (changed) {
            this.notifyObservers();
        }
    }

    public boolean isSearchInProjectFiles() {
        return this.mySearchInProjectFiles;
    }

    public void setSearchInProjectFiles(boolean searchInProjectFiles) {
        boolean changed = this.mySearchInProjectFiles != searchInProjectFiles;
        this.mySearchInProjectFiles = searchInProjectFiles;
        if (changed) {
            this.notifyObservers();
        }
    }

    public Pattern compileRegExp() {
        String toFind = this.getStringToFind();
        Pattern pattern = this.myPattern;
        if (pattern == PatternUtil.NOTHING) {
            int flags;
            int n = flags = this.isCaseSensitive() ? 8 : 74;
            if (toFind.contains("\\n")) {
                String modifiedStringToFind = StringUtil.replace(toFind, "\\n|.", ".");
                if (!(modifiedStringToFind = StringUtil.replace(modifiedStringToFind, ".|\\n", ".")).equals(toFind)) {
                    flags |= 0x20;
                    toFind = modifiedStringToFind;
                }
            }
            try {
                this.myPattern = pattern = Pattern.compile(toFind, flags);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                this.myPattern = null;
            }
        }
        return pattern;
    }

    public static enum SearchContext {
        ANY,
        IN_STRING_LITERALS,
        IN_COMMENTS,
        EXCEPT_STRING_LITERALS,
        EXCEPT_COMMENTS,
        EXCEPT_COMMENTS_AND_STRING_LITERALS;

    }

    @FunctionalInterface
    public static interface FindModelObserver {
        public void findModelChanged(FindModel var1);
    }
}

