/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer
extends LineTokenizerBase<String> {
    private final char[] myChars;
    private final String myText;

    public LineTokenizer(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/LineTokenizer", "<init>"));
        }
        this.myChars = text2.toCharArray();
        this.myText = text2;
    }

    @NotNull
    public String[] execute() {
        ArrayList<String> lines = new ArrayList<String>();
        this.doExecute(lines);
        String[] stringArray = ArrayUtil.toStringArray(lines);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/LineTokenizer", "execute"));
        }
        return stringArray;
    }

    @Override
    protected void addLine(List<String> lines, int start, int end, boolean appendNewLine) {
        if (appendNewLine) {
            lines.add(this.myText.substring(start, end) + "\n");
        } else {
            lines.add(this.myText.substring(start, end));
        }
    }

    @Override
    protected char charAt(int index) {
        return this.myChars[index];
    }

    @Override
    protected int length() {
        return this.myChars.length;
    }

    @Override
    @NotNull
    protected String substring(int start, int end) {
        String string = this.myText.substring(start, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/LineTokenizer", "substring"));
        }
        return string;
    }

    @NotNull
    public static String concatLines(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/LineTokenizer", "concatLines"));
        }
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line);
        }
        String string = buffer.substring(0, buffer.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/LineTokenizer", "concatLines"));
        }
        return string;
    }

    @NotNull
    public static String correctLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/LineTokenizer", "correctLineSeparators"));
        }
        String string = LineTokenizer.concatLines(new LineTokenizer(text2).execute());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/LineTokenizer", "correctLineSeparators"));
        }
        return string;
    }
}

