/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.EventListener;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LibraryTable {
    @NotNull
    public Library[] getLibraries();

    public Library createLibrary();

    public Library createLibrary(@NonNls String var1);

    public void removeLibrary(@NotNull Library var1);

    @NotNull
    public Iterator<Library> getLibraryIterator();

    @Nullable
    public Library getLibraryByName(@NotNull String var1);

    public String getTableLevel();

    public LibraryTablePresentation getPresentation();

    default public boolean isEditable() {
        return true;
    }

    @NotNull
    public ModifiableModel getModifiableModel();

    public void addListener(@NotNull Listener var1);

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    public void removeListener(@NotNull Listener var1);

    public static interface Listener
    extends EventListener {
        default public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLibrary", "com/intellij/openapi/roots/libraries/LibraryTable$Listener", "afterLibraryAdded"));
            }
        }

        default public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/libraries/LibraryTable$Listener", "afterLibraryRenamed"));
            }
        }

        default public void beforeLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/libraries/LibraryTable$Listener", "beforeLibraryRemoved"));
            }
        }

        default public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/libraries/LibraryTable$Listener", "afterLibraryRemoved"));
            }
        }
    }

    public static interface ModifiableModel
    extends Disposable {
        public Library createLibrary(String var1);

        public Library createLibrary(String var1, @Nullable PersistentLibraryKind var2);

        public Library createLibrary(String var1, @Nullable PersistentLibraryKind var2, @Nullable ProjectModelExternalSource var3);

        public void removeLibrary(@NotNull Library var1);

        public void commit();

        @NotNull
        public Iterator<Library> getLibraryIterator();

        @Nullable
        public Library getLibraryByName(@NotNull String var1);

        @NotNull
        public Library[] getLibraries();

        public boolean isChanged();
    }
}

