/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.JavaNullMethodArgumentIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.JavaNullMethodArgumentUtil");

    public static boolean hasNullArgument(@NotNull PsiMethod method, int argumentIdx) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "hasNullArgument"));
        }
        boolean[] result = new boolean[]{false};
        JavaNullMethodArgumentUtil.searchNullArgument(method, argumentIdx, expression -> {
            result[0] = true;
            return false;
        });
        return result[0];
    }

    public static void searchNullArgument(@NotNull PsiMethod method, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "searchNullArgument"));
        }
        if (nullArgumentProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullArgumentProcessor", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "searchNullArgument"));
        }
        PsiParameter parameter = method.getParameterList().getParameters()[argumentIdx];
        if (parameter.getType() instanceof PsiEllipsisType) {
            return;
        }
        Collection<VirtualFile> candidateFiles = JavaNullMethodArgumentUtil.getFilesWithPotentialNullPassingCalls(method, argumentIdx);
        long start = System.currentTimeMillis();
        JavaNullMethodArgumentUtil.processCallsWithNullArguments(method, argumentIdx, nullArgumentProcessor, candidateFiles);
        long duration = System.currentTimeMillis() - start;
        if (duration > 200L) {
            LOG.trace("Long nullable argument search for " + method.getName() + "(" + PsiUtil.getMemberQualifiedName(method) + "): " + duration + "ms, " + candidateFiles.size() + " files");
        }
    }

    private static void processCallsWithNullArguments(@NotNull PsiMethod method, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor, Collection<VirtualFile> candidateFiles) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "processCallsWithNullArguments"));
        }
        if (nullArgumentProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullArgumentProcessor", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "processCallsWithNullArguments"));
        }
        if (candidateFiles.isEmpty()) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.filesScope(method.getProject(), candidateFiles);
        MethodReferencesSearch.search(method, scope, true).forEach(ref -> {
            if (nullArgumentProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullArgumentProcessor", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "lambda$processCallsWithNullArguments$1"));
            }
            PsiExpression argument = JavaNullMethodArgumentUtil.getCallArgument(ref, argumentIdx);
            if (argument instanceof PsiLiteralExpression && argument.textMatches("null")) {
                return nullArgumentProcessor.process(argument);
            }
            return true;
        });
    }

    @Nullable
    private static PsiExpression getCallArgument(PsiReference ref, int argumentIdx) {
        PsiExpressionList argumentList = JavaNullMethodArgumentUtil.getCallArgumentList(ref.getElement());
        PsiExpression[] arguments = argumentList == null ? PsiExpression.EMPTY_ARRAY : argumentList.getExpressions();
        return argumentIdx < arguments.length ? arguments[argumentIdx] : null;
    }

    @Nullable
    private static PsiExpressionList getCallArgumentList(@Nullable PsiElement psi) {
        PsiElement parent;
        PsiElement psiElement = parent = psi == null ? null : psi.getParent();
        if (parent instanceof PsiCallExpression) {
            return ((PsiCallExpression)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)parent).getArgumentList();
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getFilesWithPotentialNullPassingCalls(@NotNull PsiMethod method, int parameterIndex) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "getFilesWithPotentialNullPassingCalls"));
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        CommonProcessors.CollectProcessor<VirtualFile> collector = new CommonProcessors.CollectProcessor<VirtualFile>(new ArrayList());
        GlobalSearchScope searchScope = GlobalSearchScopeUtil.toGlobalSearchScope(method.getUseScope(), method.getProject());
        searchScope = searchScope.intersectWith(GlobalSearchScopesCore.projectProductionScope(method.getProject()));
        fileBasedIndex.getFilesWithKey(JavaNullMethodArgumentIndex.INDEX_ID, Collections.singleton(new JavaNullMethodArgumentIndex.MethodCallData(method.getName(), parameterIndex)), collector, searchScope);
        Collection<VirtualFile> collection = collector.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "getFilesWithPotentialNullPassingCalls"));
        }
        return collection;
    }
}

