/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectAndLibrariesScope
extends GlobalSearchScope {
    protected final ProjectFileIndex myProjectFileIndex;
    protected final boolean mySearchOutsideRootModel;
    private String myDisplayName = PsiBundle.message("psi.search.scope.project.and.libraries", new Object[0]);

    public ProjectAndLibrariesScope(Project project) {
        this(project, false);
    }

    public ProjectAndLibrariesScope(Project project, boolean searchOutsideRootModel) {
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.mySearchOutsideRootModel = searchOutsideRootModel;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/ProjectAndLibrariesScope", "contains"));
        }
        return this.myProjectFileIndex.isInContent(file) || this.myProjectFileIndex.isInLibraryClasses(file) || this.myProjectFileIndex.isInLibrarySource(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/ProjectAndLibrariesScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/ProjectAndLibrariesScope", "compare"));
        }
        List<OrderEntry> entries1 = this.myProjectFileIndex.getOrderEntriesForFile(file1);
        List<OrderEntry> entries2 = this.myProjectFileIndex.getOrderEntriesForFile(file2);
        if (entries1.size() != entries2.size()) {
            return 0;
        }
        int res = 0;
        for (OrderEntry entry1 : entries1) {
            Module module = entry1.getOwnerModule();
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            OrderEntry entry2 = moduleFileIndex.getOrderEntryForFile(file2);
            if (entry2 == null) {
                return 0;
            }
            int aRes = entry2.compareTo(entry1);
            if (aRes == 0) {
                return 0;
            }
            if (res == 0) {
                res = aRes;
                continue;
            }
            if (res == aRes) continue;
            return 0;
        }
        return res;
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.mySearchOutsideRootModel;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/ProjectAndLibrariesScope", "isSearchInModuleContent"));
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    @Override
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        return project != null ? ModuleManager.getInstance(project).getUnloadedModuleDescriptions() : Collections.emptySet();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectAndLibrariesScope", "getDisplayName"));
        }
        return string;
    }

    public void setDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/psi/search/ProjectAndLibrariesScope", "setDisplayName"));
        }
        this.myDisplayName = displayName;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectAndLibrariesScope", "intersectWith"));
        }
        if (scope.isSearchOutsideRootModel()) {
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectAndLibrariesScope", "intersectWith"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectAndLibrariesScope", "intersectWith"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/ProjectAndLibrariesScope", "uniteWith"));
        }
        if (scope.isSearchOutsideRootModel()) {
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectAndLibrariesScope", "uniteWith"));
            }
            return globalSearchScope;
        }
        ProjectAndLibrariesScope projectAndLibrariesScope = this;
        if (projectAndLibrariesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectAndLibrariesScope", "uniteWith"));
        }
        return projectAndLibrariesScope;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

